#include <nds.h>
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <string.h>
#include <stdarg.h>
#include "common.h"

static char *top_menu_data[] = {"Game", "Options", "Help", NULL};
static char *sub_menu_data[][10] = {
	{"New Game (Choose Puzzle)", "New Game (Random Puzzle)", "Load Game", "Save Game", "Hint", NULL},
	{"{confirm_moves} Confirm All Moves", "{insta_own} Reveal Mistakes", "{reveal_solution} Show Final Solution", NULL},
	{"How to Play", "Options Help", "About", NULL},
};

u16 bg0map[1024];
u16 bg1map[1024];

static int eval_var(char *var)
{
	// poor man's indirect variable reference
	if(strcmp(var, "confirm_moves") == 0) {
		return confirm_moves;
	} else if(strcmp(var, "insta_own") == 0) {
		return insta_own;
	} else if(strcmp(var, "reveal_solution") == 0) {
		return reveal_solution;
	}

	return 0;
}

static char *checkbox_hack(char *str)
{
	char *p, *p2;
	char varname[32];
	char *ret;

	ret = strdup(str);
	if(!ret) {
		return str;
	}

	p = strchr(ret, '{');
	if(p) {
		p2 = strchr(p, '}');
		if(p2) {
			memcpy(varname, p + 1, p2 - p);
			varname[p2 - p - 1] = '\0';

			*p = (eval_var(varname) ? 251 : ' ');
			memmove(p + 1, p2 + 1, strlen(p2));
		}
	}

	return ret;
}

void main_screen_clear()
{
	int i;

	for(i = 0; i < 32 * 24; i++) {
		bg0map[i] = (15 << 12) | (u16)' ';
	}

	memset(bg1map, 0, 32*24*2);
}

static void main_screen_print_char(int col, int row, int ch)
{
	bg0map[col + row * 32] = (15 << 12) | (u16)ch;
}

static void main_screen_hili_char(int col, int row, int hili)
{
	bg1map[col + row * 32] = (0 << 12) | (hili ? 1 : 0);
}

static void main_screen_print(int col, int row, int hili, char *str)
{
	while(*str != '\0') {
		if(*str == '\n') {
			col = 0;
			row++;
		} else {
			main_screen_print_char(col, row, *str);
			main_screen_hili_char(col, row, hili);
		}

		col++;
		if(col >= 32) {
			col = 0;
			row++;
		}

		str++;
	}
}

void main_screen_printf(int col, int row, int hili, char *fmt, ...)
{
	static char buf[1024];
	va_list args;

	va_start(args, fmt);
	vsnprintf(buf, 1024, fmt, args); buf[1023] = '\0';
	va_end(args);

	main_screen_print(col, row, hili, buf);
}

void draw_menu(int menu_id, int sel_id)
{
	assert(menu_id >= 0);

	char *temp;

	clear_screen();
	main_screen_clear();
	flip();

	int i;
	for(i = 0; i < num_menus(); i++) {
		main_screen_printf(i * 10, 0, (i == menu_id ? 1 : 0), top_menu_data[i]);
	}

	for(i = 0; i < num_menu_entries(menu_id); i++) {
		temp = checkbox_hack(sub_menu_data[menu_id][i]);
		main_screen_printf(menu_id * 10, 1 + i, (i == sel_id ? 1 : 0), temp);
		free(temp);
	}
}

void draw_howto_screen()
{
	clear_screen();
	main_screen_clear();

	main_screen_printf(0, 0, 0, "How To Play Sudoku:");
	main_screen_printf(0, 2, 0, "Sudoku is a logic puzzle game");
	main_screen_printf(0, 3, 0, "played on a 9x9 grid, which is");
	main_screen_printf(0, 4, 0, "divided into nine 3x3 grids.");
	main_screen_printf(0, 6, 0, "The goal is to fill the grid");
	main_screen_printf(0, 7, 0, "with the numbers 1 - 9.  Here's");
	main_screen_printf(0, 8, 0, "the catch: you canot use the");
	main_screen_printf(0, 9, 0, "same number more than once in");
	main_screen_printf(0, 10, 0, "any row, column, or 3x3 grid.");
	main_screen_printf(0, 12, 0, "Each Sudoku puzzle starts out");
	main_screen_printf(0, 13, 0, "with some numbers already placed");
	main_screen_printf(0, 14, 0, "on the grid; it's up to you to");
	main_screen_printf(0, 15, 0, "figure out the rest.");
	main_screen_printf(0, 17, 0, "Easier puzzles can be solved");
	main_screen_printf(0, 18, 0, "just by process of elimination,");
	main_screen_printf(0, 19, 0, "while more difficult ones may");
	main_screen_printf(0, 20, 0, "require looking ahead or making");
	main_screen_printf(0, 21, 0, "educated guesses.");

	flip();
}

void draw_options_help_screen()
{
	clear_screen();
	main_screen_clear();

	main_screen_printf(0, 0, 0, "Options Help:");
	main_screen_printf(0, 2, 0, "Confirm All Moves:");
	main_screen_printf(0, 4, 0, "When enabled, numbers will be");
	main_screen_printf(0, 5, 0, "entered as a guess initially,");
	main_screen_printf(0, 6, 0, "requiring you to press OK to");
	main_screen_printf(0, 7, 0, "confirm them.");
	main_screen_printf(0, 8, 0, "When disabled, numbers you enter");
	main_screen_printf(0, 9, 0, "will take effect immediatly.");
	main_screen_printf(0, 11, 0, "Reveal Mistakes:");
	main_screen_printf(0, 13, 0, "When enabled, you will be");
	main_screen_printf(0, 14, 0, "alerted immediately if you");
	main_screen_printf(0, 15, 0, "enter a number incorrectly.");
	main_screen_printf(0, 17, 0, "When disabled, you will only");
	main_screen_printf(0, 18, 0, "be informed of mistakes once");
	main_screen_printf(0, 19, 0, "the entire puzzle has been");
	main_screen_printf(0, 20, 0, "filled out (though you will");
	main_screen_printf(0, 21, 0, "likely discover the error");
	main_screen_printf(0, 22, 0, "sooner).");

	flip();
}

void draw_about_screen()
{
	clear_screen();
	main_screen_clear();

	main_screen_printf(0, 0, 0, "SudokuDS version " VERSION);
	main_screen_printf(0, 2, 0, "by Dopefish");
	main_screen_printf(0, 3, 0, "http://vespenegas.com");

	flip();
}

int draw_board_selection_screen(int numpuzzles)
{
	static int page = 0;
	int i;
	touchPosition tp;

puzzlepicker:

	clear_screen();
	main_screen_clear();
	main_screen_printf(0, 0, 0, "PUZZLE             ATTEMPTS  WON");

	for(i = page * 20; i < (page + 1) * 20 && i < numpuzzles; i++) {
		main_screen_printf(0, 2 + i - page * 20, 0, "Board %3d - %8s  %2d %c", i + 1, stock_puzzle_difficulties[i], attempts[i], (wins[i] ? 251 : ' '));
	}

	main_screen_printf(12, 23, 0, "PAGE %d", page + 1);
	if(page > 0)
		main_screen_printf(0, 23, 0, "PREV");
	if(page < numpuzzles / 20 - (numpuzzles % 20 ? 0 : 1))
		main_screen_printf(28, 23, 0, "NEXT");

	flip();

	while(1) {
		swiWaitForVBlank();
		scanKeys();

		if(keysHeld() & KEY_LID) {
			enter_sleep_mode();
		}

		if(keysDown() & KEY_TOUCH) {
			tp = touchReadXY();

			if(tp.py >= 2 * 8 && tp.py < 22 * 8 ) {
				if(page * 20 + (tp.py - 2 * 8) / 8 < numpuzzles)
					return page * 20 + (tp.py - 2 * 8) / 8;
			} else if(tp.py >= 23 * 8 && tp.px < 4 * 8 && page > 0) {
				page--;
				goto puzzlepicker;
			} else if(tp.py >= 23 * 8 && tp.px >= 256 - 4 * 8 && page < numpuzzles / 20 - (numpuzzles % 20 ? 0 : 1)) {
				page++;
				goto puzzlepicker;
			}
		}

		if(keysDown() & (KEY_START | KEY_B)) {
			return -1;
		}
	}
}

int touched_menu(int touchx, int touchy, int menu_id)
{
	assert(menu_id >= 0);

	int max;
	int i;

	if(touchy < 8) {
 		max = num_menus();
		for(i = 0; i < max; i++) {
			if(touchx >= i * 10 * 8 && touchx < (i * 10 + strlen(top_menu_data[i])) * 8) {
				return 100 + i;
			}
		}

		return 0;
	}

	max = num_menu_entries(menu_id);
	for(i = 0; i < max; i++) {
		if(touchy >= (i + 1) * 8 && touchy < (i + 2) * 8 &&
			touchx >= menu_id * 10 * 8 && touchx < (menu_id * 10 + strlen(sub_menu_data[menu_id][i])) * 8)
		{
			return i + 1;
		}
	}

	return 0;
}

int num_menus()
{
	int i;
	char **p;

	for(i = 0, p = &top_menu_data[0]; *p; i++, p++);

	return i;
}

int num_menu_entries(int menu_id)
{
	assert(menu_id >= 0);

	int i;
	char **p;

	for(i = 0, p = &sub_menu_data[menu_id][0]; *p; i++, p++);

	return i;
}

menu_type menu_pick(int menu_id, int sel_id)
{
	// this is a really poor way to implement this
	switch(menu_id) {
		case 0:
			switch(sel_id) {
				case 0:
					return MENU_NEW_SELECT;
				case 1:
					return MENU_NEW_RANDOM;
				case 2:
					return MENU_LOAD;
				case 3:
					return MENU_SAVE;
				case 4:
					return MENU_HINT;
			}

			break;
		case 1:
			switch(sel_id) {
				case 0:
					confirm_moves = !confirm_moves;
					break;
				case 1:
					insta_own = !insta_own;
					break;
				case 2:
					reveal_solution = !reveal_solution;
					break;
			}
			break;
		case 2:
			switch(sel_id) {
				case 0:
					draw_howto_screen();
					wait_for_keypress(KEY_A | KEY_B | KEY_TOUCH);
					break;
				case 1:
					draw_options_help_screen();
					wait_for_keypress(KEY_A | KEY_B | KEY_TOUCH);
					break;
				case 2:
					draw_about_screen();
					wait_for_keypress(KEY_A | KEY_B | KEY_TOUCH);
					break;
			}
			break;
	}

	return 0;
}

