#include <nds.h>
#include <stdio.h>
#include <stdlib.h>
#include <fat.h>
#include <string.h>
#include <time.h>
#include "sound_ipc.h"
#include "common.h"
#include "hili_icon.h"
#include "splash.h"
#include "congrats.h"

u16 *screen;

int confirm_moves = 0;
int insta_own = 1;
int pause_timer = 0;
int reveal_solution = 0;

//---------------------------------------------------------------------------------
int done_sleeping;
void enter_sleep_mode()
{
	/* save the current IRQs, and turn off everything except the FIFO */
	unsigned long oldIE = REG_IE;
	REG_IE = IRQ_FIFO_NOT_EMPTY;

   	/* tell ARM7 to sleep */
	REG_IPC_FIFO_TX = FIFO_CMD_SLEEP_MODE;

	/* wait until the ARM7 tells us to wake up */
	done_sleeping = 0;
	while(!done_sleeping)
		swiWaitForIRQ();

	/* wait a bit longer until returning power */
	while(REG_VCOUNT != 0);
	while(REG_VCOUNT == 0);
	while(REG_VCOUNT != 0);

	/* restore power, and restore IRQs */
	powerON(POWER_LCD);
	REG_IE = oldIE;
}

//---------------------------------------------------------------------------------
u32 wait_for_keypress(u32 keymask)
{
	u32 kd;

	// wait until they've let go
	while(keysHeld() & keymask) { scanKeys(); swiWaitForVBlank(); }

	// wait until they pressed it
	do {
	   	swiWaitForVBlank();
		scanKeys();
		kd = keysDown();

		if(keysHeld() & KEY_LID) {
			enter_sleep_mode();
		}
	} while(!(kd & keymask));

	// wait until they release it
	while(keysHeld() & kd) { scanKeys(); swiWaitForVBlank(); }

	// return the key(s) pressed
	return kd;
}

//---------------------------------------------------------------------------------
static int getSize(uint8 *source, uint16 *dest, uint32 arg) { return *(uint32*)source; }
static uint8 readByte(uint8 *source) { return *source; }
static TDecompressionStream my_decomp = { getSize, NULL, readByte };

void congratulations_screen()
{
	consoleClear();

	swiDecompressLZSSVram((void*)congratsBitmap, screen, 0, &my_decomp);

	main_screen_printf(23, 1, 0, "Time:");
	main_screen_printf(25, 2, 0, "%d:%02d", elapsed_seconds / 60, elapsed_seconds % 60);
	main_screen_printf(23, 4, 0, "Mistakes:");
	main_screen_printf(25, 5, 0, "%d", mistakes);
	main_screen_printf(0, 19, 0, "Press A");
	main_screen_printf(0, 20, 0, "to start");
	main_screen_printf(0, 21, 0, "a new game");

	flip();

	wait_for_keypress(KEY_A);

	clear_screen();
	main_screen_clear();
	flip();
}

void splash_screen()
{
	swiDecompressLZSSVram((void*)splashBitmap, screen, 0, &my_decomp);

	BG_PALETTE[255] = RGB15(0,0,0);
	main_screen_printf(10, 17, 0, "Version " VERSION);

	flip();

	wait_for_keypress(KEY_A | KEY_B | KEY_X | KEY_Y | KEY_START | KEY_TOUCH);

	BG_PALETTE[255] = RGB15(31,31,31);
	clear_screen();
	main_screen_clear();
	flip();
}

//---------------------------------------------------------------------------------
menu_type menu()
{
	u32 kd;
	touchPosition tp;
	int redraw = 1;
	int active_menu = 0;
	int hili_selection = 0;

	while(1) {
		swiWaitForVBlank();

		if(redraw) {
			draw_menu(active_menu, hili_selection);
			flip();
		}

		scanKeys();
		kd = keysDown();

		redraw = 0;

		if(keysHeld() & KEY_LID) {
			enter_sleep_mode();
		}

		if(kd & KEY_TOUCH) {
			tp = touchReadXY();

			int sel = touched_menu(tp.px, tp.py, active_menu);
			if(sel >= 100) {
				// we touched a top-level menu; switch to it
				active_menu = sel - 100;
				hili_selection = 0;
				redraw = 1;
			} else if(sel) {
				// we touched a menu selection; make it go
				hili_selection = sel - 1;
				menu_type pick = menu_pick(active_menu, hili_selection);
				if(pick) return pick;
				redraw = 1;
			} else if(tp.py > (num_menu_entries(active_menu) + 2) * 8) {
				// we touched way below all the menu choices; return to game
				return 0;
			}
		}

		if(kd & (KEY_START | KEY_B)) {
			return 0;
		} else if(kd & KEY_LEFT) {
			active_menu--;
			if(active_menu < 0) active_menu = num_menus() - 1;
			redraw = 1;
		} else if(kd & KEY_RIGHT) {
			active_menu++;
			if(active_menu >= num_menus()) active_menu = 0;
			redraw = 1;
		} else if(kd & KEY_UP) {
			hili_selection--;
			if(hili_selection < 0) hili_selection = num_menu_entries(active_menu) - 1;
			redraw = 1;
		} else if(kd & KEY_DOWN) {
			hili_selection++;
			if(hili_selection >= num_menu_entries(active_menu)) hili_selection = 0;
			redraw = 1;
		} else if(kd & KEY_A) {
			menu_type pick = menu_pick(active_menu, hili_selection);
			if(pick) return pick;
			redraw = 1;
		}
	}
}

//---------------------------------------------------------------------------------
int main(void)
{
	u32 kd;
	touchPosition tp;
	int boxx = 0, boxy = 0, temp;
	int redraw, num_stock_puzzles, current_board_id, have_started;

	// start up the system
	powerON(POWER_ALL);
	irqInit();
	irqSet(IRQ_VBLANK, VblankHandler);
	irqEnable(IRQ_VBLANK);

	// setup the main screen as a fancy framebuffer
	videoSetMode(MODE_5_2D | DISPLAY_BG0_ACTIVE | DISPLAY_BG1_ACTIVE | DISPLAY_BG3_ACTIVE);
	vramSetMainBanks(VRAM_A_MAIN_BG, VRAM_B_MAIN_BG, VRAM_C_MAIN_BG, VRAM_D_MAIN_BG);
	BG0_CR = BG_32x32 | BG_COLOR_16 | BG_MAP_BASE(2) | BG_TILE_BASE(1);
	BG1_CR = BG_32x32 | BG_COLOR_256 | BG_MAP_BASE(4) | BG_TILE_BASE(0);
	BG3_CR = BG_BMP16_256x256 | BG_BMP_BASE(2);
	BG3_XDX = 1 << 8;
	BG3_XDY = 0;
	BG3_YDX = 0;
	BG3_YDY = 1 << 8;
	BG3_CX = 0;
	BG3_CY = 0;

	// setup the subscreen as a standard console
	videoSetModeSub(MODE_0_2D | DISPLAY_BG0_ACTIVE);
	vramSetBankH(VRAM_H_SUB_BG);
	SUB_BG0_CR = BG_MAP_BASE(8);
	BG_PALETTE_SUB[255] = RGB15(31,31,31);
	consoleInitDefault((u16*)SCREEN_BASE_BLOCK_SUB(8), (u16*)CHAR_BASE_BLOCK_SUB(0), 16);

	BG_PALETTE[0] = RGB15(0,0,0);
	BG_PALETTE[13] = RGB15(13,17,31);
	BG_PALETTE[255] = RGB15(31,31,31);
	DC_FlushRange((u8*)CHAR_BASE_BLOCK_SUB(0), 256 * 16 * 2);
	dmaCopy((u8*)CHAR_BASE_BLOCK_SUB(0), (u8*)CHAR_BASE_BLOCK(1), 256 * 16 * 2);
	DC_FlushRange(hili_iconTiles, hili_iconTilesLen);
	dmaCopy(hili_iconTiles, (u8*)CHAR_BASE_BLOCK(0) + 64, hili_iconTilesLen);

	// setup the FIFO
	REG_IPC_FIFO_CR = IPC_FIFO_ENABLE | IPC_FIFO_SEND_CLEAR;
	irqSet(IRQ_FIFO_NOT_EMPTY, FifoHandler);
	irqEnable(IRQ_FIFO_NOT_EMPTY);
	REG_IPC_FIFO_CR = IPC_FIFO_ENABLE | IPC_FIFO_RECV_IRQ;

	// init sound
	init_sound();

	iprintf("Dopefish's Sudoku\n");

	// init FAT
	if(!fatInitDefault()) {
		iprintf("WARNING: no libfat-supported\n");
		iprintf("device found.  You will not be\n");
		iprintf("able to save or play additional\n");
		iprintf("puzzles.\n");
	}

	// install the guru meditation handler
	defaultExceptionHandler();

	lcdMainOnBottom();

	// init graphics buffer
	screen = malloc(256 * 256 * 2);
	if(screen == NULL) {
		iprintf("Out of Memory\n");
		while(1);
	}
	clear_screen();
	flip();

	srand(time(NULL));

	num_stock_puzzles = load_stock_boards();
	load_progress();
	iprintf("Loaded %d stock puzzles\n", num_stock_puzzles);

	splash_screen();

new_game:

	if(num_stock_puzzles == 0) {
		current_board_id = -1;
	} else {
		int i = 0;
		do {
			current_board_id = rand() % num_stock_puzzles;
			i++;
		} while(wins[current_board_id] > 0 && i < 50);
	}

pick_game:

	if(!load_game(current_board_id)) {
		new_game(current_board_id);
	}

	solve_board();

	have_started = 0;
	redraw = 1;
	pause_timer = 0;

	console_gotoxy(0, 4);
	iprintf("                                ");
	console_gotoxy(0, 4);
	iprintf("Puzzle # %d: %s\n", current_board_id + 1, difficulty);
	console_gotoxy(0, 9);

	// main loop
	while(1) {
		swiWaitForVBlank();

		console_gotoxy(0, 5);
		iprintf("%d:%02d\n", elapsed_seconds / 60, elapsed_seconds % 60);
		console_gotoxy(0, 9);

		if(redraw) {
			main_screen_clear();
			draw_grid();
			draw_controls();
			hili_box(boxx, boxy);
			flip();
		}

		scanKeys();
		kd = keysDown();

		redraw = 0;

		if(keysHeld() & KEY_LID) {
			enter_sleep_mode();
		}

		if(kd & KEY_TOUCH) {
			tp = touchReadXY();
			//iprintf("touch (%d,%d)\n", tp.px, tp.py);

			if(touched_box(tp.px, tp.py, &boxx, &boxy)) {
				hili_box(boxx, boxy);
				redraw = 1;
			} else {
				int control = touched_control(tp.px, tp.py);
				if(control >= 1 && control <= 9) {
					if(can_guess(boxx, boxy)) {
						if(!confirm_moves) {
							if(!have_started) {
								attempts[current_board_id]++;
								have_started = 1;
							}

							put_number(boxx, boxy, control);

							if(insta_own || num_empty_boxes() == 0) {
								int won = check_board();
								if(won == 1) {
									pause_timer = 1;
									refresh_board(0);
									flip();

									congratulations_screen();

									wins[current_board_id]++;
									save_progress(num_stock_puzzles);

									goto new_game; // sue me
								} else if(won == -1) {
									if(insta_own)
									   	erase_box(boxx, boxy);

									mistakes++;
									console_gotoxy(0, 7);
									iprintf("                                ");
									console_gotoxy(0, 7);
									iprintf("Wrong!\n");
									console_gotoxy(0, 9);
								}
							}

							redraw = 1;
						} else {
							put_guess(boxx, boxy, control);
							redraw = 1;
						}
					} else {
						console_gotoxy(0, 7);
						iprintf("                                ");
						console_gotoxy(0, 7);
						iprintf("You cannot change that square.\n");
						console_gotoxy(0, 9);
					}
				} else if(control == 100) { // delete
					if(can_save(boxx, boxy)) {
						erase_box(boxx, boxy);
						redraw = 1;
					} else if(!insta_own && can_guess(boxx, boxy)) {
						erase_box(boxx, boxy);
						redraw = 1;
					} else {
						console_gotoxy(0, 7);
						iprintf("                                ");
						console_gotoxy(0, 7);
						iprintf("You cannot delete that square.\n");
						console_gotoxy(0, 9);
					}
				} else if(control == 200) { // ok
					if(!confirm_moves) {
						console_gotoxy(0, 7);
						iprintf("                                ");
						console_gotoxy(0, 7);
						iprintf("There is no need to click OK.\n");
						console_gotoxy(0, 9);
					} else if(can_save(boxx, boxy)) {
						if(!have_started) {
							attempts[current_board_id]++;
							have_started = 1;
						}

						put_number(boxx, boxy, get_guess(boxx, boxy));

						if(insta_own || num_empty_boxes() == 0) {
							int won = check_board();
							if(won == 1) {
								pause_timer = 1;

								refresh_board(0);
								flip();

								congratulations_screen();

								wins[current_board_id]++;
								save_progress(num_stock_puzzles);

								goto new_game; // sue me
							} else if(won == -1) {
								if(insta_own)
									erase_box(boxx, boxy);

								mistakes++;
								console_gotoxy(0, 7);
								iprintf("                                ");
								console_gotoxy(0, 7);
								iprintf("Wrong!\n");
								console_gotoxy(0, 9);
							}
						}

						redraw = 1;
					} else {
						console_gotoxy(0, 7);
						iprintf("                                ");
						console_gotoxy(0, 7);
						iprintf("Nothing to save in that square.\n");
						console_gotoxy(0, 9);
					}
				} else if(control == 300) { // menu
					pause_timer = 1;

					menu_type sel = menu();
					switch(sel) {
						case MENU_NEW_SELECT:
							save_progress(num_stock_puzzles);
							temp = draw_board_selection_screen(num_stock_puzzles);
							if(temp >= 0) {
								current_board_id = temp;
								goto pick_game;
							}
							break;
						case MENU_NEW_RANDOM:
							save_progress(num_stock_puzzles);
							goto new_game;
						case MENU_LOAD:
							save_progress(num_stock_puzzles);
							load_game(current_board_id);
							break;
						case MENU_SAVE:
							save_game(current_board_id);
							save_progress(num_stock_puzzles);
							break;
						case MENU_HINT:
							give_hint(&boxx, &boxy);
							break;
						default:
							break;
					}

					pause_timer = 0;
					refresh_board(reveal_solution);
					redraw = 1;
				}
			}
		}

		if((kd & KEY_UP) && boxy > 0) {
			boxy--;
			redraw = 1;
		} else if((kd & KEY_DOWN) && boxy < 8) {
			boxy++;
			redraw = 1;
		} else if((kd & KEY_LEFT) && boxx > 0) {
			boxx--;
			redraw = 1;
		} else if((kd & KEY_RIGHT) && boxx < 8) {
			boxx++;
			redraw = 1;
		} else if(kd & KEY_START) {
			pause_timer = 1;

			menu_type sel = menu();
			switch(sel) {
				case MENU_NEW_SELECT:
					save_progress(num_stock_puzzles);
					temp = draw_board_selection_screen(num_stock_puzzles);
					if(temp >= 0) {
						current_board_id = temp;
						goto pick_game;
					}
					break;
				case MENU_NEW_RANDOM:
					save_progress(num_stock_puzzles);
					goto new_game;
				case MENU_LOAD:
					save_progress(num_stock_puzzles);
					load_game(current_board_id);
					break;
				case MENU_SAVE:
					save_game(current_board_id);
					save_progress(num_stock_puzzles);
					break;
				case MENU_HINT:
					give_hint(&boxx, &boxy);
					break;
				default:
					break;
			}

			pause_timer = 0;
			refresh_board(reveal_solution);
			redraw = 1;
		}
	}

	return 0;
}

