#include <nds.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <assert.h>
#include <sys/dir.h>
#include "common.h"

int starting_board[9][9];
int the_board[9][9];
int guesses[9][9];
int mistakes;
char difficulty[32];
unsigned elapsed_seconds;

#define MAX_PUZZLES 1024
int *stock_puzzles[MAX_PUZZLES];
char *stock_puzzle_difficulties[MAX_PUZZLES];
int attempts[MAX_PUZZLES];
int wins[MAX_PUZZLES];

static int vblanks_since_tick;

void VblankHandler()
{
	if(!pause_timer) {
		vblanks_since_tick++;

		while(vblanks_since_tick >= 60) {
			vblanks_since_tick -= 60;
			elapsed_seconds++;
		}
	}
}

char *chomp(char *str)
{
	char *p;

	p = str;
	while(*p != '\0') {
		if(*p == '\r' || *p == '\n') {
			*p = '\0';
			break;
		}
		p++;
	}

	return str;
}

void new_game(int board_id)
{
	if(board_id >= 0) {
		strcpy(difficulty, stock_puzzle_difficulties[board_id]);
		memcpy(starting_board, stock_puzzles[board_id], sizeof(int) * 9 * 9);
	} else {
		sprintf(difficulty, "Default");
		memset(starting_board, 0, 9 * 9 * sizeof(int));
	}

	memcpy(the_board, starting_board, 9 * 9 * sizeof(int));
	memset(guesses, 0, 9 * 9 * sizeof(int));
	mistakes = 0;
	elapsed_seconds = 0;

	refresh_board(0);
}

void save_game(int board_id)
{
	FILE *fp;
	char temp[128];

	sprintf(temp, "/sudokuds/board%d.sav", board_id);

	fp = fopen(temp, "wb");
	if(fp) {
		fwrite(starting_board, sizeof(int), 9 * 9, fp);
		fputs(difficulty, fp); fputc('\n', fp);
		fwrite(the_board, sizeof(int), 9 * 9, fp);
		fwrite(guesses, sizeof(int), 9 * 9, fp);
		fwrite(&mistakes, sizeof(int), 1, fp);
		fwrite(&elapsed_seconds, sizeof(unsigned), 1, fp);
		fclose(fp);
	}
}

int load_game(int board_id)
{
	FILE *fp;
	char temp[128];
	int ret;

	sprintf(temp, "/sudokuds/board%d.sav", board_id);

	fp = fopen(temp, "rb");
	if(fp) {
		fread(starting_board, sizeof(int), 9 * 9, fp);
		fgets(difficulty, 32, fp);
	   	chomp(difficulty);
		fread(the_board, sizeof(int), 9 * 9, fp);
		fread(guesses, sizeof(int), 9 * 9, fp);
		fread(&mistakes, sizeof(int), 1, fp);
		fread(&elapsed_seconds, sizeof(unsigned), 1, fp);
		fclose(fp);

		ret = 1;
	} else {
		ret = 0;
	}

	refresh_board(0);

	return ret;
}

void load_progress()
{
	FILE *fp;
	int i;

	fp = fopen("/sudokuds/progress.dat", "rb");
	if(fp) {
		while(!feof(fp)) {
			if(fread(&i, sizeof(int), 1, fp)) {
				fread(&attempts[i], sizeof(int), 1, fp);
				fread(&wins[i], sizeof(int), 1, fp);
			}
		}

		fclose(fp);
	}
}

void save_progress(int num_boards)
{
	FILE *fp;
	int i;

	fp = fopen("/sudokuds/progress.dat", "wb");
	if(fp) {
		for(i = 0; i < num_boards; i++) {
			if(attempts[i] || wins[i]) {
				fwrite(&i, sizeof(int), 1, fp);
				fwrite(&attempts[i], sizeof(int), 1, fp);
				fwrite(&wins[i], sizeof(int), 1, fp);
			}
		}

		fclose(fp);
	}
}

static int qsort_compare(const void *p1, const void *p2)
{
	return strcasecmp(* (char * const *) p1, * (char * const *) p2);
}

typedef struct {
	char *diff;
	int puz[9 * 9];
} builtin_puzzle_type;

#define NUM_BUILTIN_PUZZLES 50
static builtin_puzzle_type builtin_puzzles[] = {
	{"easy", {6,4,0,5,7,0,0,0,0,0,0,3,6,4,0,0,0,1,5,0,0,0,0,2,3,4,0,4,0,8,0,0,7,0,1,0,0,7,0,4,0,1,0,8,0,0,5,0,8,0,0,4,0,2,0,1,9,3,0,0,0,0,7,7,0,0,0,9,6,8,0,0,0,0,0,0,8,5,0,3,9, }},
	{"medium", {0,0,1,8,0,0,4,0,0,5,4,0,0,3,1,0,0,0,7,0,0,9,0,0,0,3,0,3,0,0,0,8,0,0,0,2,0,0,6,0,0,0,7,0,0,2,0,0,0,5,0,0,0,8,0,6,0,0,0,3,0,0,4,0,0,0,2,7,0,0,9,1,0,0,7,0,0,8,5,0,0, }},
	{"hard", {8,0,3,9,0,0,0,2,0,0,0,0,8,3,0,1,0,0,6,0,0,0,0,5,0,0,0,7,0,0,0,0,0,0,3,1,4,0,1,0,0,0,8,0,2,3,5,0,0,0,0,0,0,6,0,0,0,4,0,0,0,0,7,0,0,7,0,1,6,0,0,0,0,8,0,0,0,9,6,0,5, }},
	{"medium", {2,1,0,0,0,0,0,4,9,0,0,8,4,0,9,1,0,0,7,0,0,0,0,0,0,0,3,0,0,4,3,0,6,2,0,0,9,0,0,0,0,0,0,0,5,0,0,3,1,0,7,6,0,0,4,0,0,0,0,0,0,0,8,0,0,1,5,0,2,4,0,0,6,5,0,0,0,0,0,3,1, }},
	{"hard", {0,1,0,2,0,5,0,3,0,0,0,7,0,0,0,9,0,0,0,3,0,8,0,9,0,2,0,0,9,2,0,0,0,3,1,0,3,0,0,0,0,0,0,0,8,0,4,8,0,0,0,7,5,0,0,6,0,5,0,3,0,4,0,0,0,4,0,0,0,1,0,0,0,2,0,6,0,4,0,7,0, }},
	{"easy", {0,0,0,5,0,8,6,9,0,4,7,0,0,0,6,0,5,0,5,0,8,1,0,0,4,0,0,3,4,0,2,0,9,8,0,6,0,0,0,0,0,0,0,0,0,6,0,2,4,0,1,0,7,3,0,0,3,0,0,4,5,0,9,0,5,0,9,0,0,0,6,1,0,1,6,7,0,5,0,0,0, }},
	{"medium", {8,7,0,0,6,0,1,0,3,0,0,3,0,0,0,0,0,2,5,0,0,0,0,3,0,8,0,0,0,7,2,0,6,0,0,0,6,0,0,0,8,0,0,0,4,0,0,0,9,0,5,8,0,0,0,1,0,4,0,0,0,0,5,9,0,0,0,0,0,6,0,0,3,0,8,0,2,0,0,4,1, }},
	{"medium", {0,7,0,0,0,0,0,2,0,0,3,6,8,0,2,1,4,0,4,0,8,0,0,0,5,0,3,0,0,0,3,9,1,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,4,2,8,0,0,0,1,0,9,0,0,0,4,0,2,0,8,7,6,0,5,3,1,0,0,6,0,0,0,0,0,8,0, }},
	{"hard", {0,0,5,0,8,0,0,1,0,0,8,2,0,3,0,0,0,0,7,0,6,0,0,2,0,0,0,0,2,9,0,0,0,0,0,8,0,4,0,8,0,3,0,9,0,1,0,0,0,0,0,3,5,0,0,0,0,5,0,0,4,0,1,0,0,0,0,4,0,8,7,0,0,9,0,0,7,0,6,0,0, }},
	{"hard", {7,1,0,0,8,0,5,0,6,0,0,5,0,0,0,0,0,3,3,0,0,0,0,7,0,9,0,0,0,3,9,0,4,0,0,0,4,0,0,0,5,0,0,0,1,0,0,0,6,0,2,8,0,0,0,3,0,2,0,0,0,0,4,5,0,0,0,0,0,2,0,0,2,0,1,0,9,0,0,5,7, }},
	{"medium", {4,0,6,0,0,0,1,0,9,0,2,0,4,0,7,0,6,0,9,0,0,8,0,6,0,0,2,0,0,4,2,0,8,5,0,0,0,0,0,0,0,0,0,0,0,0,0,3,9,0,4,7,0,0,7,0,0,5,0,3,0,0,1,0,5,0,6,0,9,0,3,0,3,0,8,0,0,0,9,0,6, }},
	{"medium", {0,9,0,0,0,0,0,2,0,0,7,2,0,6,0,4,3,0,8,0,0,7,0,9,0,0,6,0,0,5,1,0,2,7,0,0,0,0,0,0,0,0,0,0,0,0,0,9,3,0,8,1,0,0,6,0,0,2,0,5,0,0,4,0,5,1,0,4,0,6,8,0,0,4,0,0,0,0,0,5,0, }},
	{"medium", {0,4,0,0,6,0,0,0,7,0,0,2,9,0,1,0,0,5,0,0,0,4,2,3,0,0,0,0,3,0,0,0,0,5,0,0,9,5,0,0,0,0,0,8,4,0,0,8,0,0,0,0,2,0,0,0,0,7,4,6,0,0,0,3,0,0,5,0,9,6,0,0,4,0,0,0,8,0,0,1,0, }},
	{"hard", {2,0,0,3,0,9,0,0,5,0,0,0,0,0,0,0,0,0,0,9,1,0,0,0,6,2,0,0,6,0,7,0,4,0,3,0,0,3,0,0,9,0,0,8,0,0,7,0,6,0,5,0,4,0,0,2,7,0,0,0,3,1,0,0,0,0,0,0,0,0,0,0,9,0,0,8,0,1,0,0,2, }},
	{"medium", {2,0,7,0,0,0,4,0,8,0,4,0,2,0,5,0,1,0,6,0,0,7,0,8,0,0,5,0,0,4,1,0,6,9,0,0,0,0,0,0,0,0,0,0,0,0,0,3,5,0,2,8,0,0,8,0,0,4,0,3,0,0,6,0,1,0,9,0,7,0,8,0,4,0,9,0,0,0,5,0,7, }},
	{"medium", {9,0,4,0,3,2,0,0,6,0,5,0,1,0,0,0,0,4,0,8,0,6,0,0,0,9,0,7,0,0,0,0,0,0,5,0,0,0,5,7,0,3,8,0,0,0,3,0,0,0,0,0,0,9,0,6,0,0,0,4,0,1,0,1,0,0,0,0,7,0,3,0,4,0,0,3,9,0,2,0,0, }},
	{"hard", {0,0,0,4,6,0,0,7,0,0,0,0,2,8,9,0,3,0,8,0,0,0,0,5,9,0,0,2,0,0,0,0,0,3,0,5,0,0,0,3,0,8,0,0,0,6,0,8,0,0,0,0,0,2,0,0,2,5,0,0,0,0,4,0,1,0,8,4,2,0,0,0,0,8,0,0,7,1,0,0,0, }},
	{"medium", {0,2,0,0,0,5,0,4,7,0,0,9,0,0,6,1,0,0,0,0,0,0,0,0,0,0,3,6,7,0,5,0,0,2,0,0,8,0,0,9,0,2,0,0,6,0,0,4,0,0,3,0,8,1,5,0,0,0,0,0,0,0,0,0,0,2,1,0,0,4,0,0,3,8,0,4,0,0,0,7,0, }},
	{"easy", {5,6,7,0,0,4,0,0,1,0,4,9,3,0,0,7,2,0,3,0,0,0,5,0,8,0,0,0,0,0,0,2,8,6,5,0,0,0,0,6,0,9,0,0,0,0,9,8,5,7,0,0,0,0,0,0,4,0,6,0,0,0,3,0,8,6,0,0,1,5,9,0,7,0,0,8,0,0,2,6,4, }},
	{"medium", {0,3,0,6,0,0,0,0,5,0,0,0,8,0,0,0,3,4,7,2,0,3,0,0,0,0,0,0,5,0,2,8,0,3,0,6,0,0,0,0,0,0,0,0,0,4,0,2,0,3,1,0,9,0,0,0,0,0,0,4,0,7,9,9,1,0,0,0,8,0,0,0,6,0,0,0,0,3,0,1,0, }},
	{"medium", {0,0,0,0,0,8,0,4,0,9,1,0,0,0,5,8,0,0,0,8,0,6,0,0,1,0,0,0,7,0,0,5,1,0,2,0,4,0,0,0,0,0,0,0,3,0,6,0,9,7,0,0,5,0,0,0,7,0,0,2,0,1,0,0,0,6,8,0,0,0,9,7,0,4,0,3,0,0,0,0,0, }},
	{"medium", {0,0,7,0,5,0,0,6,0,0,0,0,0,0,0,8,0,0,1,8,5,6,4,0,0,0,3,3,0,2,1,0,0,4,0,0,0,0,0,0,2,0,0,0,0,0,0,4,0,0,9,7,0,2,4,0,0,0,8,3,9,7,6,0,0,9,0,0,0,0,0,0,0,5,0,0,7,0,3,0,0, }},
	{"medium", {0,3,0,5,0,4,0,0,6,0,0,0,0,7,0,5,0,8,0,0,0,0,3,0,2,7,0,0,6,0,0,0,0,0,1,9,0,0,0,7,0,1,0,0,0,4,1,0,0,0,0,0,2,0,0,4,3,0,9,0,0,0,0,9,0,5,0,1,0,0,0,0,2,0,0,6,0,5,0,8,0, }},
	{"medium", {1,0,3,0,0,0,6,0,5,0,7,0,8,0,6,0,1,0,4,0,0,9,0,5,0,0,2,0,0,1,7,0,8,5,0,0,0,0,0,0,0,0,0,0,0,0,0,6,3,0,1,4,0,0,5,0,0,4,0,2,0,0,8,0,1,0,5,0,9,0,4,0,9,0,4,0,0,0,2,0,6, }},
	{"medium", {6,0,0,0,1,0,0,2,8,3,0,0,7,2,0,0,0,0,9,2,5,0,0,0,0,0,0,0,0,0,2,0,0,3,0,9,0,3,0,0,0,0,0,4,0,5,0,8,0,0,9,0,0,0,0,0,0,0,0,0,6,8,4,0,0,0,0,6,1,0,0,7,8,9,0,0,7,0,0,0,5, }},
	{"medium", {7,0,0,0,0,4,0,3,0,0,0,0,3,5,0,0,2,0,0,1,0,7,0,0,0,0,9,0,8,4,0,9,0,0,0,0,1,0,0,2,0,3,0,0,4,0,0,0,0,6,0,5,1,0,5,0,0,0,0,1,0,4,0,0,7,0,0,8,2,0,0,0,0,9,0,6,0,0,0,0,3, }},
	{"easy", {0,0,9,0,0,6,7,0,0,0,3,0,4,1,0,0,8,0,2,0,5,7,0,0,3,0,6,7,0,0,0,2,0,8,1,0,0,2,0,8,0,7,0,3,0,0,9,8,0,6,0,0,0,4,9,0,2,0,0,1,5,0,8,0,4,0,0,5,8,0,2,0,0,0,1,6,0,0,4,0,0, }},
	{"hard", {5,0,0,1,0,0,0,7,6,0,2,0,0,4,0,0,0,0,9,1,0,0,0,7,0,3,0,1,0,9,0,2,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,3,0,9,0,4,0,4,0,6,0,0,0,1,5,0,0,0,0,1,0,0,6,0,8,6,0,0,0,5,0,0,9, }},
	{"medium", {0,7,0,4,0,8,0,9,0,5,0,0,3,0,9,0,0,1,0,6,0,0,7,0,0,8,0,0,0,4,0,0,0,8,0,0,3,2,0,0,0,0,0,4,9,0,0,7,0,0,0,6,0,0,0,1,0,0,9,0,0,2,0,4,0,0,8,0,1,0,0,7,0,5,0,6,0,4,0,3,0, }},
	{"medium", {0,5,0,7,3,2,0,6,0,9,0,0,0,0,0,0,0,4,0,0,8,0,0,0,3,0,0,3,7,0,2,0,9,0,4,5,0,0,0,0,6,0,0,0,0,6,9,0,3,0,1,0,8,7,0,0,7,0,0,0,1,0,0,4,0,0,0,0,0,0,0,8,0,8,0,9,1,5,0,7,0, }},
	{"hard", {0,5,0,3,0,0,0,0,0,0,0,3,0,8,0,0,0,1,0,0,8,0,7,4,5,2,0,0,0,6,0,0,0,0,0,7,0,7,2,0,9,0,4,3,0,8,0,0,0,0,0,6,0,0,0,9,5,1,4,0,2,0,0,7,0,0,0,6,0,3,0,0,0,0,0,0,0,2,0,9,0, }},
	{"easy", {2,0,0,0,1,0,0,9,8,8,5,0,6,0,0,0,1,0,0,0,7,4,0,8,2,0,0,0,0,5,0,7,0,4,6,0,3,0,0,2,0,1,0,0,9,0,7,1,0,5,0,3,0,0,0,0,6,3,0,5,8,0,0,0,4,0,0,0,9,0,2,6,7,8,0,0,6,0,0,0,5, }},
	{"fiendish", {0,1,0,0,0,6,0,9,5,0,0,6,0,0,7,1,0,0,0,0,0,0,0,0,0,0,4,4,9,0,3,0,0,6,0,0,8,0,0,7,0,1,0,0,2,0,0,2,0,0,9,0,8,1,5,0,0,0,0,0,0,0,0,0,0,3,9,0,0,8,0,0,7,6,0,8,0,0,0,2,0, }},
	{"hard", {0,0,0,0,0,0,0,3,8,0,0,4,0,0,9,0,0,0,6,0,3,7,0,5,0,0,0,9,4,0,0,7,0,3,0,2,0,0,0,5,0,4,0,0,0,5,0,1,0,9,0,0,7,6,0,0,0,9,0,1,2,0,5,0,0,0,4,0,0,6,0,0,8,5,0,0,0,0,0,0,0, }},
	{"medium", {0,0,2,0,0,0,5,0,0,0,0,7,5,0,6,1,0,0,3,0,0,0,7,0,0,0,6,0,7,9,8,0,1,6,2,0,0,0,0,0,0,0,0,0,0,0,8,6,7,0,4,3,5,0,7,0,0,0,1,0,0,0,5,0,0,3,9,0,5,8,0,0,0,0,8,0,0,0,9,0,0, }},
	{"medium", {0,3,0,0,1,0,0,9,0,0,0,0,7,0,4,0,8,0,0,0,0,0,6,0,0,7,5,5,0,0,0,0,8,9,3,0,0,8,0,2,0,5,0,6,0,0,1,7,9,0,0,0,0,4,6,5,0,0,8,0,0,0,0,0,2,0,3,0,1,0,0,0,0,7,0,0,2,0,0,1,0, }},
	{"hard", {0,0,9,0,0,0,0,1,0,8,3,0,0,0,0,0,7,4,0,0,5,6,0,0,3,8,0,4,0,0,0,1,5,0,6,0,0,0,0,0,8,0,0,0,0,0,5,0,9,2,0,0,0,7,0,2,7,0,0,4,8,0,0,5,6,0,0,0,0,0,4,2,0,8,0,0,0,0,6,0,0, }},
	{"medium", {0,3,0,9,0,0,0,6,0,0,0,0,1,0,0,0,4,5,0,0,5,2,0,4,9,8,0,0,8,2,0,0,0,0,0,0,7,0,0,0,0,0,0,0,8,0,0,0,0,0,0,1,5,0,0,6,9,5,0,8,3,0,0,3,5,0,0,0,7,0,0,0,0,4,0,0,0,6,0,1,0, }},
	{"medium", {8,0,1,0,0,0,4,0,9,0,6,0,2,0,8,0,5,0,4,0,0,1,0,9,0,0,6,0,0,4,6,0,3,5,0,0,0,0,0,0,0,0,0,0,0,0,0,2,7,0,4,1,0,0,2,0,0,8,0,1,0,0,5,0,8,0,5,0,7,0,3,0,5,0,7,0,0,0,2,0,8, }},
	{"hard", {0,0,8,0,0,0,4,0,0,0,0,3,1,0,4,5,0,0,6,0,0,0,8,0,0,0,2,0,5,2,3,0,9,6,4,0,0,0,0,0,0,0,0,0,0,0,7,4,6,0,5,9,3,0,2,0,0,0,5,0,0,0,4,0,0,1,9,0,6,8,0,0,0,0,5,0,0,0,7,0,0, }},
	{"medium", {1,0,0,0,0,8,0,6,0,0,0,0,1,4,0,0,9,0,0,4,0,3,0,0,0,0,2,0,2,9,0,5,0,0,0,0,6,0,0,4,0,7,0,0,3,0,0,0,0,2,0,7,5,0,4,0,0,0,0,5,0,2,0,0,7,0,0,8,6,0,0,0,0,8,0,2,0,0,0,0,5, }},
	{"medium", {0,2,6,0,0,0,1,0,0,0,0,0,9,6,0,0,0,3,8,0,0,0,0,3,0,0,4,0,0,5,6,0,7,0,8,0,0,8,0,0,3,0,0,7,0,0,3,0,8,0,4,5,0,0,9,0,0,2,0,0,0,0,1,1,0,0,0,7,8,0,0,0,0,0,3,0,0,0,2,4,0, }},
	{"easy", {0,0,0,3,0,9,2,1,0,6,3,0,0,0,2,0,8,0,2,0,1,8,0,0,7,0,0,9,1,0,5,0,4,6,0,2,0,0,0,0,0,0,0,0,0,8,0,2,9,0,3,0,4,1,0,0,7,0,0,8,3,0,5,0,6,0,7,0,0,0,9,4,0,4,9,6,0,1,0,0,0, }},
	{"hard", {0,0,1,0,7,6,0,0,0,0,0,8,2,0,0,9,0,0,0,0,0,9,0,0,0,6,7,0,0,4,5,0,0,7,0,8,0,8,0,0,0,0,0,9,0,9,0,2,0,0,3,4,0,0,5,7,0,0,0,9,0,0,0,0,0,3,0,0,7,1,0,0,0,0,0,8,5,0,6,0,0, }},
	{"medium", {3,0,9,1,0,5,6,0,7,0,0,2,0,0,0,4,0,0,0,6,0,0,0,0,0,3,0,0,0,1,7,0,2,5,0,0,6,0,0,0,0,0,0,0,2,0,0,7,5,0,8,3,0,0,0,2,0,0,0,0,0,6,0,0,0,3,0,0,0,8,0,0,8,0,6,4,0,9,7,0,1, }},
	{"easy", {0,0,7,0,0,5,1,0,0,0,1,0,3,2,0,0,4,0,4,0,9,1,0,0,6,0,3,8,0,0,0,9,0,4,1,0,0,3,0,7,0,6,0,8,0,0,6,4,0,1,0,0,0,7,2,0,1,0,0,7,3,0,5,0,9,0,0,5,1,0,6,0,0,0,8,9,0,0,2,0,0, }},
	{"medium", {0,0,4,6,0,9,0,0,0,0,5,0,0,0,0,4,7,0,8,1,0,0,0,7,2,0,0,9,0,6,2,0,0,0,3,0,0,0,0,0,7,0,0,0,0,0,4,0,0,0,5,8,0,1,0,0,8,7,0,0,0,9,3,0,3,1,0,0,0,0,5,0,0,0,0,1,0,6,7,0,0, }},
	{"hard", {5,0,0,4,0,0,0,6,7,0,9,0,0,8,0,0,0,0,4,7,0,0,0,1,0,8,0,2,0,7,0,3,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,4,0,7,0,2,0,3,0,5,0,0,0,2,4,0,0,0,0,1,0,0,7,0,9,8,0,0,0,6,0,0,1, }},
	{"hard", {0,8,7,0,5,0,9,0,0,3,0,0,0,0,0,0,0,1,2,0,6,0,1,0,0,0,0,8,0,1,9,0,0,5,0,0,0,4,0,0,0,0,0,9,0,0,0,9,0,0,6,3,0,8,0,0,0,0,4,0,7,0,6,4,0,0,0,0,0,0,0,9,0,0,3,0,8,0,4,1,0, }},
	{"easy", {0,6,2,3,0,8,4,7,0,0,0,0,0,0,0,0,0,0,4,5,0,0,0,0,0,6,3,0,0,5,4,0,3,7,0,0,0,1,0,0,2,0,0,9,0,0,0,9,7,0,1,8,0,0,6,8,0,0,0,0,0,5,1,0,0,0,0,0,0,0,0,0,0,7,3,5,0,9,6,4,0, }},
};

int load_builtin_boards()
{
	int i;

	for(i = 0; i < NUM_BUILTIN_PUZZLES; i++) {
		stock_puzzles[i] = (int*) builtin_puzzles[i].puz;
		stock_puzzle_difficulties[i] = builtin_puzzles[i].diff;
	}

	return i;
}

int load_stock_boards()
{
	DIR_ITER *dir;
	FILE *fp;
	struct stat st;
	char name[256];
	int i;
	int temp[81];
	char temp_diff[32];
	char *board_files[128];
	char **ptr;

	i = 0;

	i += load_builtin_boards();

	dir = diropen("/sudokuds/");
	if(dir) {
		ptr = &board_files[0];

		while(dirnext(dir, name, &st) == 0 && ptr - &board_files[0] < 128) {
			if(!(st.st_mode & S_IFDIR) && strcasecmp(name + strlen(name) - 4, ".brd") == 0) {
				//iprintf("Found '%s'\n", name);
				*ptr = malloc(strlen("/sudokuds/") + strlen(name) + 1);
				if(!*ptr) {
					dirclose(dir);
					return 0;
				} else {
					sprintf(*ptr, "/sudokuds/%s", name);
					ptr++;
				}
			}
		}

		*ptr = NULL;

		dirclose(dir);
	} else {
		board_files[0] = NULL;
		ptr = &board_files[0];
	}

	qsort(&board_files[0], ptr - &board_files[0], sizeof(char*), qsort_compare);

	for(ptr = &board_files[0]; *ptr; ptr++) {
		//iprintf("Loading '%s'\n", *ptr);
		fp = fopen(*ptr, "rb");
		if(fp) {
			while(!feof(fp) && i < MAX_PUZZLES) {
				if(fread(temp, sizeof(int), 9 * 9, fp)) {
					fgets(temp_diff, 128, fp);
					temp_diff[0] = toupper(temp_diff[0]);
					chomp(temp_diff);

					stock_puzzles[i] = malloc(sizeof(int) * 9 * 9);
					if(stock_puzzles[i] == NULL) {
						fclose(fp);
						return i;
					} else {
						memcpy(stock_puzzles[i], temp, sizeof(int) * 9 * 9);
					}

					stock_puzzle_difficulties[i] = malloc(strlen(temp_diff) + 1);
					if(stock_puzzle_difficulties[i] == NULL) {
						fclose(fp);
						return i;
					} else {
						strcpy(stock_puzzle_difficulties[i], temp_diff);
					}

					i++;
				}
			}

			fclose(fp);
		}

		free(*ptr);

		if(i >= MAX_PUZZLES)
			break;
	}

	return i;
}

void give_hint(int *boxx, int *boxy)
{
	int r, c;

	do {
		c = rand() % 9;
		r = rand() % 9;
	} while(the_board[r][c] != 0);

	the_board[r][c] = solution[r][c];
	refresh_board(0);

	if(boxx != NULL && boxy != NULL) {
		*boxx = c;
		*boxy = r;
	}
}

int get_guess(int x, int y)
{
	assert(x >= 0 && x < 9 && y >= 0 && y < 9);

	return guesses[y][x];
}

int get_number(int x, int y)
{
	assert(x >= 0 && x < 9 && y >= 0 && y < 9);

	return the_board[y][x];
}

void put_guess(int x, int y, int num)
{
	assert(x >= 0 && x < 9 && y >= 0 && y < 9 && num >= 1 && num <= 9);

	draw_number(x, y, num, MODE_GUESS);
	guesses[y][x] = num;
}

void put_number(int x, int y, int num)
{
	assert(x >= 0 && x < 9 && y >= 0 && y < 9 && num >= 1 && num <= 9);

	draw_number(x, y, num, MODE_PLAYER);
	the_board[y][x] = num;
	guesses[y][x] = 0;
}

void erase_box(int x, int y)
{
	assert(x >= 0 && x < 9 && y >= 0 && y < 9);

	clear_box(x, y);
	guesses[y][x] = 0;
	the_board[y][x] = 0;
}

int can_save(int x, int y)
{
	assert(x >= 0 && x < 9 && y >= 0 && y < 9);

	if(guesses[y][x] != 0)
		return 1;
	else
		return 0;
}

int can_guess(int x, int y)
{
	assert(x >= 0 && x < 9 && y >= 0 && y < 9);

	if(the_board[y][x] == 0)
		return 1;
	else if(!insta_own && starting_board[y][x] == 0)
		return 1;
	else
		return 0;
}

void refresh_board(int reveal_solution)
{
	int x, y;

	for(y = 0; y < 9; y++) {
		for(x = 0; x < 9; x++) {
			if(starting_board[y][x] != 0)
				draw_number(x, y, starting_board[y][x], MODE_STARTING);
			else if(the_board[y][x] != 0)
				draw_number(x, y, the_board[y][x], MODE_PLAYER);
			else if(reveal_solution && solution[y][x] != 0)
				draw_number(x, y, solution[y][x], MODE_SOLUTION);
			else if(guesses[y][x] != 0)
				draw_number(x, y, guesses[y][x], MODE_GUESS);
			else
				draw_number(x, y, 0, MODE_PLAYER);
		}
	}

	flip();
}

int num_empty_boxes()
{
	int x, y, boxes;

	boxes = 0;
	for(y = 0; y < 9; y++)
		for(x = 0; x < 9; x++)
			if(the_board[y][x] == 0)
				boxes++;

	return boxes;
}

int check_board()
{
	int row, col, complete = 1;
	for(row = 0; row < 9; row++) {
		for(col = 0; col < 9; col++) {
			if(the_board[row][col] != 0) {
				if(the_board[row][col] != solution[row][col]) {
					return -1;
				}
			} else {
				complete = 0;
			}
		}
	}

	return (complete ? 1 : 0);
}

