#ifndef __COMMON_H
#define __COMMON_H

#include <nds.h>

#ifndef MAX
#define MAX(a,b) ((a) > (b) ? (a) : (b))
#endif
#ifndef MIN
#define MIN(a,b) ((a) < (b) ? (a) : (b))
#endif

#ifndef VERSION
#define VERSION "0.1 Alpha"
#endif

typedef enum {
	MODE_STARTING,
	MODE_PLAYER,
	MODE_GUESS,
	MODE_SOLUTION
} mode_type;

typedef enum {
	MENU_NOTHING,
	MENU_NEW_SELECT,
	MENU_NEW_RANDOM,
	MENU_LOAD,
	MENU_SAVE,
	MENU_HINT
} menu_type;

extern u16 *screen;

extern int the_board[9][9];
extern int guesses[9][9];
extern int starting_board[9][9];
extern char difficulty[32];
extern char *stock_puzzle_difficulties[];
extern int attempts[];
extern int wins[];
extern unsigned elapsed_seconds;
extern int mistakes;

extern int confirm_moves;
extern int insta_own;
extern int reveal_solution;
extern int pause_timer;

extern u16 bg0map[1024];
extern u16 bg1map[1024];

extern int solution[9][9];

static inline u16 get_pixel(int x, int y)
{
	return screen[y * 256 + x];
}

static inline void put_pixel(int x, int y, u16 col)
{
	screen[y * 256 + x] = col | BIT(15);
}

static inline void flip()
{
	DC_FlushRange(screen, 256 * 256 * 2);
	dmaCopy(screen, (u16*)BG_BMP_RAM(2), 256 * 256);
	dmaCopy((u8*)screen + (256 * 256), (u8*)BG_BMP_RAM(2) + (256 * 256), 256 * 256);

	DC_FlushRange(bg0map, 1024 * 2);
	dmaCopy(bg0map, (u16*)SCREEN_BASE_BLOCK(2), 1024 * 2);
	DC_FlushRange(bg1map, 1024 * 2);
	dmaCopy(bg1map, (u16*)SCREEN_BASE_BLOCK(4), 1024 * 2);
}

static inline void console_gotoxy(int col, int row)
{
	iprintf("\x1b[%d;%dH", row, col);
}

u32 wait_for_keypress(u32 keymask);
void clear_screen();
void draw_line(int x1, int y1, int x2, int y2, u16 col);
void draw_box(int x, int y, int w, int h, u16 col);
void draw_grid();
void draw_controls();
void draw_number(int x, int y, int num, mode_type mode);
void hili_box(int x, int y);
void clear_box(int x, int y);
int touched_box(int touchx, int touchy, int *x, int *y);
int touched_control(int touchx, int touchy);

void enter_sleep_mode();
void VblankHandler();
void new_game(int which);
int load_game(int board_id);
void save_game(int board_id);
void give_hint(int *boxx, int *boxy);
int load_stock_boards();
void load_progress();
void save_progress(int num_boards);
void put_number(int x, int y, int num);
void put_guess(int x, int y, int num);
void erase_box(int x, int y);
int can_save(int x, int y);
int can_guess(int x, int y);
int get_guess(int x, int y);
int get_number(int x, int y);
int check_board();
void refresh_board(int reveal_solution);
int num_empty_boxes();

void draw_menu(int menu_id, int sel_id);
int touched_menu(int touchx, int touchy, int menu_id);
int num_menus();
int num_menu_entries(int menu_id);
menu_type menu_pick(int menu_id, int sel_id);
void main_screen_clear();
void main_screen_printf(int col, int row, int hili, char *fmt, ...);
void draw_howto_screen();
void draw_options_help_screen();
void draw_about_screen();
int draw_board_selection_screen(int numpuzzles);

int solve_board();

#endif
