#include <nds.h>
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include "common.h"

static u16 background_color = RGB15(0,0,0);
static u16 grid_color = RGB15(31,31,31);
static u16 hili_color = RGB15(31,31,0);
static u16 numbers_color[] = { RGB15(31,31,31), RGB15(31,10,10), RGB15(25,15,15), RGB15(10,10,31) };
static u16 controls_color = RGB15(22,22,31);

void draw_line(int x1, int y1, int x2, int y2, u16 col)
{
	// Bresenham's algorithm
	int x, y, deltax, deltay, xinc1, xinc2, yinc1, yinc2, numadd, numpixels, num, den, curpixel;

	deltax = abs(x2 - x1);
	deltay = abs(y2 - y1);
	x = x1;
	y = y1;

	if(x2 >= x1) {
		xinc1 = 1;
		xinc2 = 1;
	} else {
		xinc1 = -1;
		xinc2 = -1;
	}

	if(y2 >= y1) {
		yinc1 = 1;
		yinc2 = 1;
	} else {
		yinc1 = -1;
		yinc2 = -1;
	}

	if(deltax >= deltay) {
		xinc1 = 0;
		yinc2 = 0;
		den = deltax;
		num = deltax / 2;
		numadd = deltay;
		numpixels = deltax;
	} else {
		xinc2 = 0;
		yinc1 = 0;
		den = deltay;
		num = deltay / 2;
		numadd = deltax;
		numpixels = deltay;
	}

	for(curpixel = 0; curpixel <= numpixels; curpixel++) {
		if(x1==218&&y1==178&&x2==215&&y2==170) iprintf("(%d, %d)\n", x, y);
		put_pixel(x, y, col);
		num += numadd;
		if(num >= den) {
			num -= den;
			x += xinc1;
			y += yinc1;
		}
		x += xinc2;
		y += yinc2;
	}
}

void draw_box(int x, int y, int w, int h, u16 col)
{
	draw_line(x, y, x + w, y, col);
	draw_line(x, y, x, y + h, col);
	draw_line(x + w, y, x + w, y + h, col);
	draw_line(x, y + h, x + w, y + h, col);
}

void clear_screen()
{
	int x, y;
	for(y = 0; y < 192; y++)
		for(x = 0; x < 256; x++)
			put_pixel(x, y, background_color);
}

static void draw_number_raw(int x0, int y0, int num, u16 col)
{
	int x, y;

	switch(num) {
		case 1:
			draw_line(x0 + 8, y0 + 2,  x0 + 8,  y0 + 14, col);
			draw_line(x0 + 5, y0 + 14, x0 + 11, y0 + 14, col);
			draw_line(x0 + 8, y0 + 2,  x0 + 6,  y0 + 4,  col);
			break;
		case 2:
			put_pixel(x0 + 6,  y0 + 4,  col);
			put_pixel(x0 + 6,  y0 + 3,  col);
			put_pixel(x0 + 7,  y0 + 2,  col);
			put_pixel(x0 + 8,  y0 + 2,  col);
			put_pixel(x0 + 9,  y0 + 2,  col);
			put_pixel(x0 + 10, y0 + 3,  col);
			put_pixel(x0 + 11, y0 + 3,  col);
			put_pixel(x0 + 12, y0 + 4,  col);
			put_pixel(x0 + 12, y0 + 5,  col);
			put_pixel(x0 + 12, y0 + 6,  col);
			put_pixel(x0 + 11, y0 + 7,  col);
			put_pixel(x0 + 10, y0 + 8,  col);
			put_pixel(x0 + 9,  y0 + 9,  col);
			put_pixel(x0 + 8,  y0 + 10, col);
			put_pixel(x0 + 7,  y0 + 11, col);
			put_pixel(x0 + 6,  y0 + 12, col);
			put_pixel(x0 + 6,  y0 + 13, col);
			draw_line(x0 + 6,  y0 + 14, x0 + 12, y0 + 14, col);
			break;
		case 3:
			put_pixel(x0 + 9,  y0 + 2,  col);
			put_pixel(x0 + 8,  y0 + 2,  col);
			put_pixel(x0 + 7,  y0 + 2,  col);
			put_pixel(x0 + 8,  y0 + 8, col);
			put_pixel(x0 + 7,  y0 + 8, col);
			put_pixel(x0 + 6,  y0 + 3, col);
			put_pixel(x0 + 10, y0 + 3,  col);
			put_pixel(x0 + 11, y0 + 3,  col);
			put_pixel(x0 + 9,  y0 + 8, col);
			put_pixel(x0 + 10, y0 + 7, col);
			put_pixel(x0 + 11, y0 + 7, col);
			put_pixel(x0 + 12, y0 + 4, col);
			put_pixel(x0 + 12, y0 + 5, col);
			put_pixel(x0 + 12, y0 + 6, col);
			put_pixel(x0 + 9,  y0 + 8,  col);
			put_pixel(x0 + 8,  y0 + 8,  col);
			put_pixel(x0 + 7,  y0 + 8,  col);
			put_pixel(x0 + 8,  y0 + 14, col);
			put_pixel(x0 + 7,  y0 + 14, col);
			put_pixel(x0 + 6,  y0 + 13, col);
			put_pixel(x0 + 10, y0 + 9,  col);
			put_pixel(x0 + 11, y0 + 9,  col);
			put_pixel(x0 + 9,  y0 + 14, col);
			put_pixel(x0 + 10, y0 + 13, col);
			put_pixel(x0 + 11, y0 + 13, col);
			put_pixel(x0 + 12, y0 + 10, col);
			put_pixel(x0 + 12, y0 + 11, col);
			put_pixel(x0 + 12, y0 + 12, col);
			break;
		case 4:
			draw_line(x0 + 10, y0 + 2, x0 + 10, y0 + 14, col);
			draw_line(x0 + 6,  y0 + 2, x0 + 6, y0 + 7, col);
			draw_line(x0 + 6,  y0 + 7, x0 + 10, y0 + 7, col);
			break;
		case 5:
			draw_line(x0 + 6,  y0 + 2, x0 + 12, y0 + 2, col);
			draw_line(x0 + 6,  y0 + 2, x0 + 6,  y0 + 8, col);
			put_pixel(x0 + 9,  y0 + 8,  col);
			put_pixel(x0 + 8,  y0 + 8,  col);
			put_pixel(x0 + 7,  y0 + 8,  col);
			put_pixel(x0 + 8,  y0 + 14, col);
			put_pixel(x0 + 7,  y0 + 14, col);
			put_pixel(x0 + 6,  y0 + 13, col);
			put_pixel(x0 + 10, y0 + 9,  col);
			put_pixel(x0 + 11, y0 + 9,  col);
			put_pixel(x0 + 9,  y0 + 14, col);
			put_pixel(x0 + 10, y0 + 13, col);
			put_pixel(x0 + 11, y0 + 13, col);
			put_pixel(x0 + 12, y0 + 10, col);
			put_pixel(x0 + 12, y0 + 11, col);
			put_pixel(x0 + 12, y0 + 12, col);
			break;
		case 6:
			draw_line(x0 + 11, y0 + 2, x0 + 4, y0 + 9, col);
			put_pixel(x0 + 9,  y0 + 8,  col);
			put_pixel(x0 + 8,  y0 + 8,  col);
			put_pixel(x0 + 7,  y0 + 8,  col);
			put_pixel(x0 + 6,  y0 + 9,  col);
			put_pixel(x0 + 5,  y0 + 9,  col);
			put_pixel(x0 + 8,  y0 + 14, col);
			put_pixel(x0 + 7,  y0 + 14, col);
			put_pixel(x0 + 6,  y0 + 13, col);
			put_pixel(x0 + 5,  y0 + 13, col);
			put_pixel(x0 + 4,  y0 + 9,  col);
			put_pixel(x0 + 4,  y0 + 10, col);
			put_pixel(x0 + 4,  y0 + 11, col);
			put_pixel(x0 + 4,  y0 + 12, col);
			put_pixel(x0 + 10, y0 + 9,  col);
			put_pixel(x0 + 11, y0 + 9,  col);
			put_pixel(x0 + 9,  y0 + 14, col);
			put_pixel(x0 + 10, y0 + 13, col);
			put_pixel(x0 + 11, y0 + 13, col);
			put_pixel(x0 + 12, y0 + 10, col);
			put_pixel(x0 + 12, y0 + 11, col);
			put_pixel(x0 + 12, y0 + 12, col);
			break;
		case 7:
			draw_line(x0 + 6,  y0 + 2, x0 + 12, y0 + 2,  col);
			draw_line(x0 + 12, y0 + 2, x0 + 8,  y0 + 14, col);
			break;
		case 8:
			put_pixel(x0 + 8,  y0 + 2,  col);
			put_pixel(x0 + 7,  y0 + 2,  col);
			put_pixel(x0 + 6,  y0 + 3,  col);
			put_pixel(x0 + 5,  y0 + 3,  col);
			put_pixel(x0 + 8,  y0 + 8,  col);
			put_pixel(x0 + 7,  y0 + 8,  col);
			put_pixel(x0 + 6,  y0 + 7,  col);
			put_pixel(x0 + 5,  y0 + 7,  col);
			put_pixel(x0 + 4,  y0 + 4,  col);
			put_pixel(x0 + 4,  y0 + 5,  col);
			put_pixel(x0 + 4,  y0 + 6,  col);
			put_pixel(x0 + 9,  y0 + 2,  col);
			put_pixel(x0 + 10, y0 + 3,  col);
			put_pixel(x0 + 11, y0 + 3,  col);
			put_pixel(x0 + 9,  y0 + 8,  col);
			put_pixel(x0 + 10, y0 + 7,  col);
			put_pixel(x0 + 11, y0 + 7,  col);
			put_pixel(x0 + 12, y0 + 4,  col);
			put_pixel(x0 + 12, y0 + 5,  col);
			put_pixel(x0 + 12, y0 + 6,  col);
			put_pixel(x0 + 6,  y0 + 9,  col);
			put_pixel(x0 + 5,  y0 + 9,  col);
			put_pixel(x0 + 8,  y0 + 14, col);
			put_pixel(x0 + 7,  y0 + 14, col);
			put_pixel(x0 + 6,  y0 + 13, col);
			put_pixel(x0 + 5,  y0 + 13, col);
			put_pixel(x0 + 4,  y0 + 10, col);
			put_pixel(x0 + 4,  y0 + 11, col);
			put_pixel(x0 + 4,  y0 + 12, col);
			put_pixel(x0 + 10, y0 + 9,  col);
			put_pixel(x0 + 11, y0 + 9,  col);
			put_pixel(x0 + 9,  y0 + 14, col);
			put_pixel(x0 + 10, y0 + 13, col);
			put_pixel(x0 + 11, y0 + 13, col);
			put_pixel(x0 + 12, y0 + 10, col);
			put_pixel(x0 + 12, y0 + 11, col);
			put_pixel(x0 + 12, y0 + 12, col);
			break;
		case 9:
			put_pixel(x0 + 9, y0 + 2, col);
			put_pixel(x0 + 8, y0 + 2, col);
			put_pixel(x0 + 7, y0 + 2, col);
			put_pixel(x0 + 6, y0 + 3, col);
			put_pixel(x0 + 5, y0 + 3, col);
			put_pixel(x0 + 9, y0 + 8, col);
			put_pixel(x0 + 8, y0 + 8, col);
			put_pixel(x0 + 7, y0 + 8, col);
			put_pixel(x0 + 6, y0 + 7, col);
			put_pixel(x0 + 5, y0 + 7, col);
			put_pixel(x0 + 4, y0 + 4, col);
			put_pixel(x0 + 4, y0 + 5, col);
			put_pixel(x0 + 4, y0 + 6, col);
			draw_line(x0 + 10, y0 + 2, x0 + 10, y0 + 14, col);
			break;
		default:
			for(y = y0; y <= y0 + 16; y++)
				for(x = x0; x <= x0 + 16; x++)
					put_pixel(x, y, 0);
	}
}

void draw_grid()
{
	// horizontal lines
	draw_line(5,5,   180,5,   grid_color); draw_line(5,6,   180,6,   grid_color);
	draw_line(5,25,  180,25,  grid_color);
	draw_line(5,44,  180,44,  grid_color);
	draw_line(5,63,  180,63,  grid_color); draw_line(5,64,  180,64,  grid_color);
	draw_line(5,83,  180,83,  grid_color);
	draw_line(5,102, 180,102, grid_color);
	draw_line(5,121, 180,121, grid_color); draw_line(5,122, 180,122, grid_color);
	draw_line(5,141, 180,141, grid_color);
	draw_line(5,160, 180,160, grid_color);
	draw_line(5,179, 180,179, grid_color); draw_line(5,180, 180,180, grid_color);

	// vertical lines
	draw_line(5,5,   5,180,   grid_color); draw_line(6,5,   6,180,   grid_color);
	draw_line(25,5,  25,180,  grid_color);
	draw_line(44,5,  44,180,  grid_color);
	draw_line(63,5,  63,180,  grid_color); draw_line(64,5,  64,180,  grid_color);
	draw_line(83,5,  83,180,  grid_color);
	draw_line(102,5, 102,180, grid_color);
	draw_line(121,5, 121,180, grid_color); draw_line(122,5, 122,180, grid_color);
	draw_line(141,5, 141,180, grid_color);
	draw_line(160,5, 160,180, grid_color);
	draw_line(179,5, 179,180, grid_color); draw_line(180,5, 180,180, grid_color);
}

void draw_controls()
{
	draw_box(210,5,   17, 17, controls_color);
	draw_box(210,24,  17, 17, controls_color);
	draw_box(210,43,  17, 17, controls_color);
	draw_box(210,62,  17, 17, controls_color);
	draw_box(210,81,  17, 17, controls_color);
	draw_box(229,5,   17, 17, controls_color);
	draw_box(229,24,  17, 17, controls_color);
	draw_box(229,43,  17, 17, controls_color);
	draw_box(229,62,  17, 17, controls_color);
	draw_box(210,114, 36, 17, controls_color);
	draw_box(210,137, 36, 17, controls_color);
	draw_box(210,163, 36, 17, controls_color);

	draw_number_raw(210,5,  1, controls_color);
	draw_number_raw(210,24, 2, controls_color);
	draw_number_raw(210,43, 3, controls_color);
	draw_number_raw(210,62, 4, controls_color);
	draw_number_raw(210,81, 5, controls_color);
	draw_number_raw(229,5,  6, controls_color);
	draw_number_raw(229,24, 7, controls_color);
	draw_number_raw(229,43, 8, controls_color);
	draw_number_raw(229,62, 9, controls_color);

	// <---
	draw_line(215,122, 240,122, controls_color);
	put_pixel(216, 121, controls_color);
	put_pixel(216, 123, controls_color);
	put_pixel(217, 120, controls_color);
	put_pixel(217, 121, controls_color);
	put_pixel(217, 123, controls_color);
	put_pixel(217, 124, controls_color);
	put_pixel(218, 119, controls_color);
	put_pixel(218, 120, controls_color);
	put_pixel(218, 121, controls_color);
	put_pixel(218, 123, controls_color);
	put_pixel(218, 124, controls_color);
	put_pixel(218, 125, controls_color);
	put_pixel(219, 118, controls_color);
	put_pixel(219, 119, controls_color);
	put_pixel(219, 120, controls_color);
	put_pixel(219, 121, controls_color);
	put_pixel(219, 123, controls_color);
	put_pixel(219, 124, controls_color);
	put_pixel(219, 125, controls_color);
	put_pixel(219, 126, controls_color);

	// O
	put_pixel(222, 140, controls_color);
	put_pixel(221, 140, controls_color);
	put_pixel(220, 141, controls_color);
	put_pixel(219, 141, controls_color);
	put_pixel(218, 142, controls_color);
	put_pixel(218, 143, controls_color);
	put_pixel(218, 144, controls_color);
	put_pixel(218, 145, controls_color);
	put_pixel(218, 146, controls_color);
	put_pixel(218, 147, controls_color);
	put_pixel(218, 148, controls_color);
	put_pixel(218, 149, controls_color);
	put_pixel(218, 150, controls_color);
	put_pixel(219, 151, controls_color);
	put_pixel(220, 151, controls_color);
	put_pixel(221, 152, controls_color);
	put_pixel(222, 152, controls_color);
	put_pixel(223, 152, controls_color);        
	put_pixel(224, 151, controls_color);
	put_pixel(225, 151, controls_color);
	put_pixel(226, 150, controls_color);
	put_pixel(226, 149, controls_color);
	put_pixel(226, 148, controls_color);
	put_pixel(226, 147, controls_color);
	put_pixel(226, 146, controls_color);
	put_pixel(226, 145, controls_color);
	put_pixel(226, 144, controls_color);
	put_pixel(226, 143, controls_color);
	put_pixel(226, 142, controls_color);
	put_pixel(225, 141, controls_color);
	put_pixel(224, 141, controls_color);
	put_pixel(223, 140, controls_color);

	// K
	draw_line(230,139, 230,152, controls_color);
	draw_line(230,146, 238,139, controls_color);
	draw_line(230,146, 238,152, controls_color);

	// M
	draw_line(212,165, 212,178, controls_color);
	draw_line(218,165, 218,178, controls_color);
	draw_line(212,165, 215,170, controls_color);
	draw_line(218,165, 215,170, controls_color);

	// E
	draw_line(220,165, 220,178, controls_color);
	draw_line(220,165, 226,165, controls_color);
	draw_line(220,178, 226,178, controls_color);
	draw_line(220,171, 226,171, controls_color);

	// N
	draw_line(228,165, 228,178, controls_color);
	draw_line(234,165, 234,178, controls_color);
	draw_line(228,165, 231,170, controls_color);
	draw_line(234,178, 231,170, controls_color);

	// U
	draw_line(236,165, 236,175, controls_color);
	draw_line(242,165, 242,175, controls_color);
	put_pixel(237, 176, controls_color);
	put_pixel(241, 176, controls_color);
	put_pixel(237, 177, controls_color);
	put_pixel(241, 177, controls_color);
	put_pixel(238, 178, controls_color);
	put_pixel(240, 178, controls_color);
	put_pixel(239, 178, controls_color);
}

static int box_corners[] = { 7, 26, 45, 65, 84, 103, 123, 142, 161, };

void draw_number(int x, int y, int num, mode_type mode)
{
	clear_box(x, y);

	draw_number_raw(box_corners[x], box_corners[y], num, numbers_color[mode]);
}

void clear_box(int x, int y)
{
	assert(x >= 0 && x < 9 && y >= 0 && y < 9);

	int r, c;
	for(r = box_corners[y]; r < box_corners[y] + 18; r++)
		for(c = box_corners[x]; c < box_corners[x] + 18; c++)
			put_pixel(c, r, background_color);
}

void hili_box(int x, int y)
{
	assert(x >= 0 && x < 9 && y >= 0 && y < 9);

	draw_box(box_corners[x] - 1, box_corners[y] - 1, 18 + 1, 18 + 1, hili_color);
}

int touched_box(int touchx, int touchy, int *x, int *y)
{
	assert(x != NULL && y != NULL);

	int i;
	for(i = 0; i < 9; i++) {
		if(touchx >= box_corners[i] && touchx <= box_corners[i] + 18) {
			*x = i;

			for(i = 0; i < 9; i++) {
				if(touchy >= box_corners[i] && touchy <= box_corners[i] + 18) {
					*y = i;
					return 1;
				}
			}

			break;
		}
	}

	return 0;
}

int touched_control(int touchx, int touchy)
{
	if(touchx >= 211 && touchx <= 245) {
		if(touchy >= 6 && touchy <= 6 + 16 && touchx <= 228) {
			return 1;
		} else if(touchy >= 24 && touchy <= 24 + 16 && touchx <= 228) {
			return 2;
		} else if(touchy >= 43 && touchy <= 43 + 16 && touchx <= 228) {
			return 3;
		} else if(touchy >= 62 && touchy <= 62 + 16 && touchx <= 228) {
			return 4;
		} else if(touchy >= 81 && touchy <= 81 + 16 && touchx <= 228) {
			return 5;
		} else if(touchy >= 5 && touchy <= 5 + 16 && touchx >= 230) {
			return 6;
		} else if(touchy >= 24 && touchy <= 24 + 16 && touchx >= 230) {
			return 7;
		} else if(touchy >= 43 && touchy <= 43 + 16 && touchx >= 230) {
			return 8;
		} else if(touchy >= 62 && touchy <= 62 + 16 && touchx >= 230) {
			return 9;
		} else if(touchy >= 115 && touchy <= 115 + 16) {
			return 100;
		} else if(touchy >= 138 && touchy <= 138 + 16) {
			return 200;
		} else if(touchy >= 164 && touchy <= 164 + 16) {
			return 300;
		}
	}

	return 0;
}

