/*---------------------------------------------------------------------------------
	$Id: template.c,v 1.4 2005/09/17 23:15:13 wntrmute Exp $

	Basic Hello World

	$Log: template.c,v $
	Revision 1.4  2005/09/17 23:15:13  wntrmute
	corrected iprintAt in templates
	
	Revision 1.3  2005/09/05 00:32:20  wntrmute
	removed references to IPC struct
	replaced with API functions
	
	Revision 1.2  2005/08/31 01:24:21  wntrmute
	updated for new stdio support

	Revision 1.1  2005/08/03 06:29:56  wntrmute
	added templates


---------------------------------------------------------------------------------*/
#include "nds.h"
#include <nds/arm9/console.h> //basic print funcionality
#include <stdio.h>
#include <stdlib.h>
#include "card.h"

//---------------------------------------------------------------------------------
int main(void) {
//---------------------------------------------------------------------------------

	videoSetMode(0);	//not using the main screen
	videoSetModeSub(MODE_0_2D | DISPLAY_BG0_ACTIVE);	//sub bg 0 will be used to print text
	vramSetBankC(VRAM_C_SUB_BG);

	SUB_BG0_CR = BG_MAP_BASE(31);

	BG_PALETTE_SUB[255] = RGB15(31,31,31);	//by default font will be rendered with color 255

	//consoleInit() is a lot more flexible but this gets you up and running quick
	consoleInitDefault((u16*)SCREEN_BASE_BLOCK_SUB(31), (u16*)CHAR_BASE_BLOCK_SUB(0), 16);

	irqInit();
	irqEnable(IRQ_VBLANK);

	int i;
	u8 temp[11];
	for(i = 0; i < PersonalData->nameLen; i++)
		temp[i] = PersonalData->name[i] & 0xFF;
	temp[i] = '\0';

	iprintf("Hi %s\n", temp);

	iprintf("\n\nPress A to dump, or B for info\n");
	iprintf("Eject and re-insert DS Card 1st\n");

	while(1) {
		scanKeys();
		if(keysDown() & KEY_A) {
			consoleClear();
			iprintf("Dumping Cardz0rz\n");
			Dump_Card();
			//iprintf("Done Dumping\n");
		} else if(keysDown() & KEY_B) {
			consoleClear();
			Show_Card();
		}

		swiWaitForVBlank();
	}

	return 0;
}
