
#ifndef ENCRYPTION_H
#define ENCRYPTION_H

void init_keycode (u32 idcode, u32 level, u32 modulo);
void crypt_64bit_down (u8* ptr);
void crypt_64bit_up (u8* ptr);

void init_key2(u64 seed0, u64 seed1);
void key2_encrypt(u8 *data);
void key2_advance(int bytes);

// KEY2 is just an XOR function; encryption and decryption are the same
// as long as the LFSR stream is sync'd correctly
#define key2_decrypt(a) key2_encrypt((a))

// registers
#define KEY2_SEED0_LOWER (*(u32*)0x40001B0)
#define KEY2_SEED0_UPPER (*(u16*)0x40001B8)
#define KEY2_SEED1_LOWER (*(u32*)0x40001B4)
#define KEY2_SEED1_UPPER (*(u16*)0x40001BA)

#endif
