#include <nds.h>
#include <string.h>
#include <stdio.h>

extern unsigned char keydata[4168];

#define KEYSIZE 0x1048
u32 keybuf [KEYSIZE/sizeof(u32)];

void crypt_64bit_up (u8* ptr) {
	u32 x = *((u32*)&ptr[4]);
	u32 y = *((u32*)&ptr[0]);
	u32 z;
	int i;

	for (i = 0; i < 0x10; i++) {
		z = keybuf[i] ^ x;
		x = keybuf[0x012 + ((z>>24)&0xff)];
		x = keybuf[0x112 + ((z>>16)&0xff)] + x;
		x = keybuf[0x212 + ((z>> 8)&0xff)] ^ x;
		x = keybuf[0x312 + ((z>> 0)&0xff)] + x;
		x = y ^ x;
		y = z;
	}

	*((u32*)&ptr[0]) = x ^ keybuf[0x10];
	*((u32*)&ptr[4]) = y ^ keybuf[0x11];
}

void crypt_64bit_down (u8* ptr) {
	u32 x = *((u32*)&ptr[4]);
	u32 y = *((u32*)&ptr[0]);
	u32 z;
	int i;

	for (i = 0x11; i > 0x01; i--) {
		z = keybuf[i] ^ x;
		x = keybuf[0x012 + ((z>>24)&0xff)];
		x = keybuf[0x112 + ((z>>16)&0xff)] + x;
		x = keybuf[0x212 + ((z>> 8)&0xff)] ^ x;
		x = keybuf[0x312 + ((z>> 0)&0xff)] + x;
		x = y ^ x;
		y = z;
	}

	*((u32*)&ptr[0]) = x ^ keybuf[0x01];
	*((u32*)&ptr[4]) = y ^ keybuf[0x00];
}

u32 bswap_32bit (u32 in) {
	u8 a,b,c,d;
	a = (u8)((in >>  0) & 0xff);
	b = (u8)((in >>  8) & 0xff);
	c = (u8)((in >> 16) & 0xff);
	d = (u8)((in >> 24) & 0xff);

	u32 out = (a << 24) | (b << 16) | (c << 8) | (d << 0);

	return out;
}

u8 keycode [12];
void apply_keycode (u32 modulo) {
	u32 scratch[2];
	int i;

	crypt_64bit_up (keycode+4);
	crypt_64bit_up (keycode+0);
	memset (scratch, 0, 8);

	for (i = 0; i < 0x12; i+=1) {
		keybuf[i] = keybuf[i] ^ bswap_32bit ( *((u32*)&keycode[(i*4) % modulo]) );
	}
	for (i = 0; i < 0x412; i+=2) {
		crypt_64bit_up ((u8*)scratch);
		keybuf[i]   = scratch[1];
		keybuf[i+1] = scratch[0];
	}
}

void init_keycode (u32 idcode, u32 level, u32 modulo) {
	memcpy (keybuf, keydata, KEYSIZE);
	*((u32*)&keycode[0]) = idcode;
	*((u32*)&keycode[4]) = idcode/2;
	*((u32*)&keycode[8]) = idcode*2;

	if (level >= 1) apply_keycode (modulo);	// first apply (always)
	if (level >= 2) apply_keycode (modulo);	// second apply (optional)
	*((u32*)&keycode[4]) = *((u32*)&keycode[4]) * 2;
	*((u32*)&keycode[8]) = *((u32*)&keycode[8]) / 2;
	if (level >= 3) apply_keycode (modulo);	// third apply (optional)
}

u64 key2_x, key2_y;
void init_key2(u64 seed0, u64 seed1)
{
	// reverse the bits in each seed var (eew, 39-bit values)

	int i;
	u8 bits[64];

	union {
		u64 big;
		u32 small[2];
	} foo;

	foo.big = 0;
	for(i = 0; i < 39; i++)
		bits[i] = (seed0 >> i) & 1;
	for(i = 0; i < 39; i++)
		if(i < 7 && bits[i])
			foo.small[1] |= BIT(6 - i);
		else if(i >= 7 && bits[i])
			foo.small[0] |= BIT(31 - (i - 7));
		//iprintf("%d", bits[i]);
	//iprintf("\n");
	key2_x = foo.big;

	foo.big = 0;
	for(i = 0; i < 39; i++)
		bits[i] = (seed1 >> i) & 1;
	for(i = 0; i < 7; i++)
		bits[32 + i] = ((seed1 >> 32) & BIT(i)) ? 1 : 0;
	for(i = 0; i < 39; i++)
		if(i < 7 && bits[i])
			foo.small[1] |= BIT(6 - i);
		else if(i >= 7 && bits[i])
			foo.small[0] |= BIT(31 - (i - 7));
		//iprintf("%d", bits[i]);
	//iprintf("\n");
	key2_y = foo.big;

	/*
	key2_x = 0;
	for(i = 0; i < 39; i++)
		if(seed0 & BIT(i))
			key2_x |= BIT(38 - i);

	key2_y = 0;
	for(i = 0; i < 39; i++)
		if(seed1 & BIT(i))
			key2_y |= BIT(38 - i);
	*/
}

void key2_encrypt(u8 *data)
{
	key2_x = (((key2_x >> 5) ^ (key2_x >> 17) ^ (key2_x >> 18) ^ (key2_x >> 31)) & 0x0FF) + (key2_x << 8);
	key2_y = (((key2_y >> 5) ^ (key2_y >> 23) ^ (key2_y >> 18) ^ (key2_y >> 31)) & 0x0FF) + (key2_y << 8);
	*data = (*data ^ key2_x ^ key2_y) & 0x0FF;
}

void key2_advance(int bytes)
{
	u8 foo;
	while(bytes > 0) {
		foo = 0;
		key2_encrypt(&foo);
		bytes--;
	}
}

