#include <nds.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fat.h>
#include "card.h"
#include "encryption.h"

int cardz0rz(const u8 *cmd, u32 *dst, u32 len, u32 flags, int skip_bytes)
{
	u32 data;
	u32 *target;
	u32 bytesread;

	cardWriteCommand(cmd);
	//CARD_CR2 = flags | CARD_ACTIVATE | CARD_nRESET | 0x07000000; // bits 24-26: data block size = 4 bytes
	CARD_CR2 = flags;
	bytesread = 0;
	target = dst + (len / 4);
	do {
		// Read data if available
		if(CARD_CR2 & CARD_DATA_READY) {
			data=CARD_DATA_RD;
			if(bytesread < skip_bytes) {
				//if(bytesread < 8) iprintf("%x ", data);
			} else if(dst < target) {
				*dst = data;
				dst++;
			}
			bytesread += 4;
		}
	} while(CARD_CR2 & CARD_BUSY);

	return(bytesread);
}

void Show_Card()
{
	static tNDSHeader boob;
	u32 i;
	char str[33];

	sysSetBusOwners(BUS_OWNER_ARM9,BUS_OWNER_ARM9);
	cardReadHeader((u8*)&boob);
	sysSetBusOwners(BUS_OWNER_ARM7,BUS_OWNER_ARM7);

	consoleClear();

	iprintf("Game Code: %c%c%c%c\n",boob.gameCode[0],boob.gameCode[1],boob.gameCode[2],boob.gameCode[3]);

	for(i = 0; i < 12; i++) {
		str[i] = boob.gameTitle[i];
	}
	str[i] = '\0';
	iprintf("Game Title: %s\n", str);

	switch(boob.deviceSize) {
		case 0: sprintf(str, "128KB"); break;
		case 1: sprintf(str, "256KB"); break;
		case 2: sprintf(str, "512KB"); break;
		case 3: sprintf(str, "1MB"); break;
		case 4: sprintf(str, "2MB"); break;
		case 5: sprintf(str, "4MB"); break;
		case 6: sprintf(str, "8MB"); break;
		case 7: sprintf(str, "16MB"); break;
		case 8: sprintf(str, "32MB"); break;
		case 9: sprintf(str, "64MB"); break;
		case 10: sprintf(str, "128MB"); break;
		case 11: sprintf(str, "256MB"); break;
		case 12: sprintf(str, "512MB"); break;
		case 13: sprintf(str, "1GB"); break;
		default: sprintf(str, "Big"); break;
	}
	iprintf("Card Size: %s\n", str);

	iprintf("Icon addr: 0x%x\n", boob.bannerOffset);
	iprintf("ARM9 addr: 0x%x\n", boob.arm9romSource);
	iprintf("ARM7 addr: 0x%x\n", boob.arm7romSource);
}

void Dump_Card()
{
	static tNDSHeader boob;
	static u8 secure_area[0x4000];
	static u8 buf[0x10C0];
	u32 i, chip_id, chip_id2, key1_skip_bytes, icky_flags_4k, icky_flags_8k, icky_flags_512, icky_flags_4;
	u32 cmd[2], iii, jjj, kkkkk, llll, mmm, nnn, addr;
	u64 key2_seed0, key2_seed1;
	u8 key2_seed_byte, first_byte_of_key2;
	u16 secure_area_crc;
	int pct;
	char rom_name[17];
	FILE *fp;

	/* gamecart_decryption (from gbatek):
	 * init_keycode(cart_header + 0x0C, 1, 0x08); // gamecode, level 1, modulo 8
	 * crypt_64bit_down(cart_header + 0x78); // rominfo (secure area disable)
	 * init_keycode(cart_header + 0x0C, 2, 0x08); // gamecode, level 2, modulo 8
	 * crypt_64bit_up(); // all KEY1 commands, 1st command byte in MSB of 64bit value
	 * finish loading secure area; calculate secure_area CRC
	 * crypt_64bit_down(secure_area + 0); // first 8 bytes of secure area
	 * init_keycode(cart_header + 0x0C, 3, 0x08); // gamecode, level 3, modulo 8
	 * crypt_64bit_down(secure_area + 0 .. 0x7F8); // each 8 bytes in first 2K of secure
	 * after decryption, ID field in 1st 8 bytes should be "encryObj"
	 * if it matches then the 1st 8 bytes are filled with 0xE7FFDEFF, otherwise whole 2K are filled by that value
	 */

	consoleClear();

#ifdef DUMP
	fatInitDefault();
#endif

	// give the ARM9 control of both slots
	sysSetBusOwners(BUS_OWNER_ARM9,BUS_OWNER_ARM9);

	// read the card header
	cardReadHeader((u8*)&boob);

	// build the filename (from the card title)
	memset(rom_name, 0, 17);
	memcpy(rom_name, boob.gameTitle, 12);
	for(i = 0; rom_name[i] != '\0'; i++);
	memcpy(&rom_name[i], ".nds", 4);
	iprintf("Dumping %s\n", rom_name);

	// read the hardware chip ID
	chip_id = cardReadID(0);
#ifdef DEBUG
	iprintf("Chip ID: %x (mode %d)\n", chip_id, chip_id & BIT(7));
#endif

	// determine flags for sending commands to the card, for various block sizes.
	// note that we're doing the KEY2 encryption ourself, so we don't use cardControl13
	icky_flags_4k = boob.cardControlBF | CARD_ACTIVATE | CARD_nRESET | (BIT(26) & ~BIT(25) & ~BIT(24)); // 4 KB block size
	icky_flags_8k = boob.cardControlBF | CARD_ACTIVATE | CARD_nRESET | BIT(26) | (BIT(24) & ~BIT(25)); // 8 KB block size
	icky_flags_512 = boob.cardControlBF | CARD_ACTIVATE | CARD_nRESET | (BIT(24) & ~BIT(25) & ~BIT(26)); // 512 B block size
	icky_flags_4 = boob.cardControlBF | CARD_ACTIVATE | CARD_nRESET | BIT(24) | BIT(25) | BIT(26); // 4 B block size

	// calculate number of dummy bytes to use in KEY1 commands (default is the minimum, 0x910)
	key1_skip_bytes = (icky_flags_4k & 0x1FFF) + ((icky_flags_4k & 0x3F0000) >> 16);
#ifdef DEBUG
	iprintf("Norm Flags: %x\n", boob.cardControl13);
	iprintf("KEY1 Flags: %x\n", boob.cardControlBF);
	iprintf("skip bytes: %x\n", key1_skip_bytes);
#endif

	// figure out the seed byte used to init KEY2
	switch(boob.deviceType & 0x7) {
		case 0: key2_seed_byte = 0xE8; break;
		case 1: key2_seed_byte = 0x4D; break;
		case 2: key2_seed_byte = 0x5A; break;
		case 3: key2_seed_byte = 0xB1; break;
		case 4: key2_seed_byte = 0x17; break;
		case 5: key2_seed_byte = 0x8F; break;
		case 6: key2_seed_byte = 0x99; break;
		case 7: key2_seed_byte = 0xD5; break;
		default: key2_seed_byte = 0; break;
	}
#ifdef DEBUG
	iprintf("KEY2 Seed byte: %x (%x)\n", boob.deviceType & 0x7, key2_seed_byte);
#endif

	// activate KEY1 encryption
	iii = 0xAAA;
	jjj = 0xBBB;
	kkkkk = 0xCCCCC;
	cmd[1] = 0x3C000000 | (iii << 12) | jjj;
	cmd[0] = kkkkk << 8;
#ifdef DEBUG
	iprintf("\ncmd= %x %x\n", cmd[0], cmd[1]);
#endif
	i = cardWriteAndRead((u8*)cmd, CARD_ACTIVATE | CARD_nRESET | 0x07000000); // bits 24-26: data block size = 4 bytes
#ifdef DEBUG
	iprintf("KEY1'd; %x\n", i);
#endif

	//init_keycode(*(u32*)boob.gameCode, 1, 8);
	//crypt_64bit_down((u8*)&boob.bfPrime1);
	init_keycode(*(u32*)boob.gameCode, 2, 8);

	// activate KEY2 encryption
	llll = 0xDDDD;
	mmm = 0xEEE;
	nnn = 0xFFF;
	cmd[1] = 0x40000000 | (llll << 12) | mmm;
	cmd[0] = (nnn << 20) | kkkkk;
#ifdef DEBUG
	iprintf("\ncmd= %x %x\n", cmd[0], cmd[1]);
#endif
	crypt_64bit_up((u8*)cmd);
	//iprintf("mmm=%x, nnn=%x\n", cmd[1] & 0xFFF, (cmd[0] >> 20) & 0xFFF);
	i = cardz0rz((u8*)cmd, (u32*)&first_byte_of_key2, 1, icky_flags_4k, key1_skip_bytes);
	kkkkk++;
#ifdef DEBUG
	iprintf("KEY2'd; %x (l=%d)\n", first_byte_of_key2, i);
#endif

	// default KEY2 seeds; note that seed1 is not changed
	key2_seed0 = 0x58C56DE0E8LL;
	key2_seed1 = 0x5C879B9B05LL;

	// set new seed0 based on the values we passed to the card above
	key2_seed0 = mmm >> 5;
	key2_seed0 <<= 32;
	key2_seed0 |= (((mmm << 12) | nnn) << 15) + 0x6000 + key2_seed_byte;

	// set the KEY2 encryption registers to match; this is probably unnecessary
	KEY2_SEED0_LOWER = key2_seed0 & 0xFFFF;
	KEY2_SEED0_UPPER = (key2_seed0 >> 32) & 0x7F;
	KEY2_SEED1_LOWER = key2_seed0 & 0xFFFF;
	KEY2_SEED1_UPPER = (key2_seed1 >> 32) & 0x7F;

	// init the LFSR streams for KEY2 (this is just a bit-reversal of the seeds)
	init_key2(key2_seed0, key2_seed1);

	// get chip ID again
	cmd[1] = 0x10000000 | (llll << 12) | iii;
	//cmd[1] = 0x00000000 | (llll << 12) | iii; // invalid command; gets stream of KEY2-encrypted 0x00
	cmd[0] = (jjj << 20) | kkkkk;
#ifdef DEBUG
	iprintf("\ncmd= %x %x\n", cmd[0], cmd[1]);
#endif
	crypt_64bit_up((u8*)cmd);
	i = cardz0rz((u8*)cmd, (u32*)&chip_id2, 4, icky_flags_4k, key1_skip_bytes);
	kkkkk++;
	key2_advance(key1_skip_bytes);
	key2_decrypt((u8*)&chip_id2);
	key2_decrypt((u8*)&chip_id2 + 1);
	key2_decrypt((u8*)&chip_id2 + 2);
	key2_decrypt((u8*)&chip_id2 + 3);
	key2_advance(0x1000 - key1_skip_bytes - sizeof(chip_id2));
#ifdef DEBUG
	iprintf("chip ID'd; %x (l=%d)\n", chip_id2, i);
#endif

	// sanity check
	if(chip_id2 == chip_id) {
		iprintf("Dumping secure area\n");
	} else {
		iprintf("Chip IDs don't match, aborting dump\n");
		return;
	}

	// get secure area (first 4K block)
	cmd[1] = 0x20000000 | (0x0004 << 12) | iii;
	cmd[0] = (jjj << 20) | kkkkk;
#ifdef DEBUG
	iprintf("\ncmd= %x %x\n", cmd[0], cmd[1]);
#endif
	crypt_64bit_up((u8*)cmd);
	i = cardz0rz((u8*)cmd, (u32*)buf, 0x10C0, icky_flags_8k, key1_skip_bytes);
	kkkkk++;
	key2_advance(key1_skip_bytes);
	for(i = 0; i < 0x10C0; i++) 
		key2_decrypt(&buf[i]);
	key2_advance(0x2000 - key1_skip_bytes - 0x10C0);
	//iprintf("secure: %x %x %x %x (l=%d)\n", buf[0], buf[1], buf[2], buf[3], i);
	if(chip_id & BIT(7)) {
		// if this bit is set, we're getting 8 chunks of 512 bytes each, with 24 bytes of filler between
		memcpy(secure_area, buf, 0x200);
		memcpy(secure_area + 0x200, buf + 0x218, 0x200);
		memcpy(secure_area + 0x400, buf + 0x430, 0x200);
		memcpy(secure_area + 0x600, buf + 0x648, 0x200);
		memcpy(secure_area + 0x800, buf + 0x860, 0x200);
		memcpy(secure_area + 0xA00, buf + 0xA78, 0x200);
		memcpy(secure_area + 0xC00, buf + 0xC90, 0x200);
		memcpy(secure_area + 0xE00, buf + 0xEA8, 0x200);
   	} else {
		// otherwise, we're getting one chunk of 4 KB
		memcpy(secure_area, buf, 0x1000);
   	}

	// get secure area (second 4K block)
	cmd[1] = 0x20000000 | (0x0005 << 12) | iii;
	cmd[0] = (jjj << 20) | kkkkk;
#ifdef DEBUG
	iprintf("cmd= %x %x\n", cmd[0], cmd[1]);
#endif
	crypt_64bit_up((u8*)cmd);
	i = cardz0rz((u8*)cmd, (u32*)buf, 0x10C0, icky_flags_8k, key1_skip_bytes);
	kkkkk++;
	key2_advance(key1_skip_bytes);
	for(i = 0; i < 0x10C0; i++)
		key2_decrypt(&buf[i]);
	key2_advance(0x2000 - key1_skip_bytes - 0x10C0);
	//iprintf("secure: %x %x %x %x (l=%d)\n", buf[0], buf[1], buf[2], buf[3], i);
	if(chip_id & BIT(7)) {
		// if this bit is set, we're getting 8 chunks of 512 bytes each, with 24 bytes of filler between
		memcpy(secure_area + 0x1000, buf, 0x200);
		memcpy(secure_area + 0x1200, buf + 0x218, 0x200);
		memcpy(secure_area + 0x1400, buf + 0x430, 0x200);
		memcpy(secure_area + 0x1600, buf + 0x648, 0x200);
		memcpy(secure_area + 0x1800, buf + 0x860, 0x200);
		memcpy(secure_area + 0x1A00, buf + 0xA78, 0x200);
		memcpy(secure_area + 0x1C00, buf + 0xC90, 0x200);
		memcpy(secure_area + 0x1E00, buf + 0xEA8, 0x200);
   	} else {
		// otherwise, we're getting one chunk of 4 KB
		memcpy(secure_area + 0x1000, buf, 0x1000);
   	}

	// get secure area (third 4K block)
	cmd[1] = 0x20000000 | (0x0006 << 12) | iii;
	cmd[0] = (jjj << 20) | kkkkk;
#ifdef DEBUG
	iprintf("cmd= %x %x\n", cmd[0], cmd[1]);
#endif
	crypt_64bit_up((u8*)cmd);
	i = cardz0rz((u8*)cmd, (u32*)buf, 0x10C0, icky_flags_8k, key1_skip_bytes);
	kkkkk++;
	key2_advance(key1_skip_bytes);
	for(i = 0; i < 0x10C0; i++)
		key2_decrypt(&buf[i]);
	key2_advance(0x2000 - key1_skip_bytes - 0x10C0);
	//iprintf("secure: %x %x %x %x (l=%d)\n", buf[0], buf[1], buf[2], buf[3], i);
	if(chip_id & BIT(7)) {
		// if this bit is set, we're getting 8 chunks of 512 bytes each, with 24 bytes of filler between
		memcpy(secure_area + 0x2000, buf, 0x200);
		memcpy(secure_area + 0x2200, buf + 0x218, 0x200);
		memcpy(secure_area + 0x2400, buf + 0x430, 0x200);
		memcpy(secure_area + 0x2600, buf + 0x648, 0x200);
		memcpy(secure_area + 0x2800, buf + 0x860, 0x200);
		memcpy(secure_area + 0x2A00, buf + 0xA78, 0x200);
		memcpy(secure_area + 0x2C00, buf + 0xC90, 0x200);
		memcpy(secure_area + 0x2E00, buf + 0xEA8, 0x200);
   	} else {
		// otherwise, we're getting one chunk of 4 KB
		memcpy(secure_area + 0x2000, buf, 0x1000);
   	}

	// get secure area (fourth 4K block)
	cmd[1] = 0x20000000 | (0x0007 << 12) | iii;
	cmd[0] = (jjj << 20) | kkkkk;
#ifdef DEBUG
	iprintf("cmd= %x %x\n", cmd[0], cmd[1]);
#endif
	crypt_64bit_up((u8*)cmd);
	i = cardz0rz((u8*)cmd, (u32*)buf, 0x10C0, icky_flags_8k, key1_skip_bytes);
	kkkkk++;
	key2_advance(key1_skip_bytes);
	for(i = 0; i < 0x10C0; i++)
		key2_decrypt(&buf[i]);
	key2_advance(0x2000 - key1_skip_bytes - 0x10C0);
	//iprintf("secure: %x %x %x %x (l=%d)\n", buf[0], buf[1], buf[2], buf[3], i);
	if(chip_id & BIT(7)) {
		// if this bit is set, we're getting 8 chunks of 512 bytes each, with 24 bytes of filler between
		memcpy(secure_area + 0x3000, buf, 0x200);
		memcpy(secure_area + 0x3200, buf + 0x218, 0x200);
		memcpy(secure_area + 0x3400, buf + 0x430, 0x200);
		memcpy(secure_area + 0x3600, buf + 0x648, 0x200);
		memcpy(secure_area + 0x3800, buf + 0x860, 0x200);
		memcpy(secure_area + 0x3A00, buf + 0xA78, 0x200);
		memcpy(secure_area + 0x3C00, buf + 0xC90, 0x200);
		memcpy(secure_area + 0x3E00, buf + 0xEA8, 0x200);
   	} else {
		// otherwise, we're getting one chunk of 4 KB
		memcpy(secure_area + 0x3000, buf, 0x1000);
   	}

	// enter main data mode
	// we do this before decrypting the secure area so we don't have to reset the KEY1 state
	cmd[1] = 0xA0000000 | (llll << 12) | iii;
	cmd[0] = (jjj << 20) | kkkkk;
#ifdef DEBUG
	iprintf("cmd= %x %x\n", cmd[0], cmd[1]);
#endif
	crypt_64bit_up((u8*)cmd);
	cardz0rz((u8*)cmd, &i, 4, icky_flags_4k, key1_skip_bytes);
	kkkkk++;
	key2_advance(key1_skip_bytes);
	key2_decrypt((u8*)&i);
	key2_decrypt((u8*)&i + 1);
	key2_decrypt((u8*)&i + 2);
	key2_decrypt((u8*)&i + 3);
	key2_advance(0x1000 - key1_skip_bytes - sizeof(i));
#ifdef DEBUG
	iprintf("Main data mode (%x)\n", i);
#endif

	// decrypt first 2KB of secure area (KEY1)
	// we use a temp buffer for this, because we want the original (encrypted) data for the actual dump
	secure_area_crc = swiCRC16(0xFFFF, secure_area, 0x4000);
#ifdef DEBUG
	iprintf("\nSecure CRC (from header): %x\n", boob.secureCRC16);
	iprintf("\nSecure CRC (calculated): %x\n", secure_area_crc);
#endif
	memcpy(buf, secure_area, 2048);
	crypt_64bit_down(buf);
	init_keycode(*(u32*)boob.gameCode, 3, 8);
	for(i = 0; i < 2048; i += 8)
		crypt_64bit_down(&buf[i]);
#ifdef DEBUG
	iprintf("Secure: %c%c%c%c%c%c%c%c\n", buf[0], buf[1], buf[2], buf[3], buf[4], buf[5], buf[6], buf[7]);
#endif

	// validate secure area
	if(secure_area_crc == boob.secureCRC16 && buf[0] == 'e' && buf[1] == 'n' && buf[2] == 'c' && buf[3] == 'r' && buf[4] == 'y' && buf[5] == 'O' && buf[6] == 'b' && buf[7] == 'j') {
		iprintf("Successfully dumped secure area.\n");
	} else {
		iprintf("Failed to dump secure area; aborting dump\n");
		return;
	}

	// get chip ID yet again
	cmd[1] = 0xB8000000;
	cmd[0] = 0;
#ifdef DEBUG
	iprintf("\ncmd= %x %x\n", cmd[0], cmd[1]);
#endif
	key2_encrypt((u8*)cmd + 7);
	key2_encrypt((u8*)cmd + 6);
	key2_encrypt((u8*)cmd + 5);
	key2_encrypt((u8*)cmd + 4);
	key2_encrypt((u8*)cmd + 3);
	key2_encrypt((u8*)cmd + 2);
	key2_encrypt((u8*)cmd + 1);
	key2_encrypt((u8*)cmd);
	i = cardz0rz((u8*)cmd, &chip_id2, 4, icky_flags_4, 0);
	key2_decrypt((u8*)&chip_id2);
	key2_decrypt((u8*)&chip_id2 + 1);
	key2_decrypt((u8*)&chip_id2 + 2);
	key2_decrypt((u8*)&chip_id2 + 3);
#ifdef DEBUG
	iprintf("chip ID'd; %x (l=%d)\n", chip_id2, i);
#endif

	// sanity check
	if(chip_id == chip_id2) {
		iprintf("Opening file for writing\n");
	} else {
		iprintf("Chip IDs don't match, aborting dump\n");
		return;
	}

	// start writing to the memory card
#ifdef DUMP
	fp = fopen(rom_name, "wb");

	fwrite(&boob, 0x200, 1, fp); // header

	memset(buf, 0, 0x200);
	for(i = 0x200; i < 0x4000; i += 0x200)
		fwrite(buf, 0x200, 1, fp); // reserved junk area

	fwrite(secure_area, 0x4000, 1, fp); // secure area
#endif

	iprintf("Dumping main ROM\n");

	// get regular ROM data (512 bytes at a time)
	iprintf("\n");
	for(pct = -1, addr = 0x8000; addr < (0x20000 << boob.deviceSize); addr += 0x200) {
		cmd[1] = 0xB7000000 | (addr >> 8);
		cmd[0] = (addr & 0xFF) << 24;
#ifdef DEBUG
		iprintf("cmd= %x %x\n", cmd[0], cmd[1]);
#endif
		key2_encrypt((u8*)cmd + 7);
		key2_encrypt((u8*)cmd + 6);
		key2_encrypt((u8*)cmd + 5);
		key2_encrypt((u8*)cmd + 4);
		key2_encrypt((u8*)cmd + 3);
		key2_encrypt((u8*)cmd + 2);
		key2_encrypt((u8*)cmd + 1);
		key2_encrypt((u8*)cmd);
		cardz0rz((u8*)cmd, (u32*)buf, 0x200, icky_flags_512, 0);
		for(i = 0; i < 0x200; i++)
			key2_decrypt(&buf[i]);
#ifdef DEBUG
		iprintf("0x%x: %x %x %x %x\n", addr, buf[0], buf[1], buf[2], buf[3], buf[4]);
#endif
		// progress indicator
		if(pct != 100 * addr / (0x20000 << boob.deviceSize)) {
			pct = 100 * addr / (0x20000 << boob.deviceSize);
			iprintf("%d%% done\n", pct);
		}
#ifdef DUMP
		fwrite(buf, 0x200, 1, fp);
#endif
	}

#ifdef DUMP
	fclose(fp);
#endif
	iprintf("Dump complete.\n");

	// give control of both slots back to ARM7
	sysSetBusOwners(BUS_OWNER_ARM7,BUS_OWNER_ARM7);
}

