#include <nds.h>
#include <stdio.h>
#include <fat.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include "sound_ipc.h"

#include "objects.h"
#include "graphics.h"

#include "systemscolor.h"
#include "oscolor.h"
#include "billsprite.h"
#include "extrassprite.h"
#include "swapsprite.h"
#include "title.h"
#include "pause.h"
#include "between.h"
#include "gameover.h"
#include "about.h"
#include "rules.h"
#include "story.h"

SpriteEntry sprites[128];
pSpriteRotation sprite_rot = (pSpriteRotation)(void*) sprites;

//---------------------------------------------------------------------------------
int done_sleeping;
void enter_sleep_mode()
{
	/* save the current IRQs, and turn off everything except the FIFO */
	unsigned long oldIE = REG_IE;
	REG_IE = IRQ_FIFO_NOT_EMPTY;

   	/* tell ARM7 to sleep */
	REG_IPC_FIFO_TX = FIFO_CMD_SLEEP_MODE;

	/* wait until the ARM7 tells us to wake up */
	done_sleeping = 0;
	while(!done_sleeping)
		swiWaitForIRQ();

	/* wait a bit longer until returning power */
	while(REG_VCOUNT != 0);
	while(REG_VCOUNT == 0);
	while(REG_VCOUNT != 0);

	/* restore power, and restore IRQs */
	powerON(POWER_LCD);
	REG_IE = oldIE;
}

//---------------------------------------------------------------------------------
int main(void)
{
	// start up the system
	powerON(POWER_ALL);
	irqInit();
	irqEnable(IRQ_VBLANK);

	// setup the main screen
	videoSetMode(MODE_3_2D | DISPLAY_BG0_ACTIVE | DISPLAY_BG1_ACTIVE | DISPLAY_BG2_ACTIVE
		| DISPLAY_BG3_ACTIVE | DISPLAY_SPR_ACTIVE | DISPLAY_SPR_1D);
	vramSetMainBanks(VRAM_A_MAIN_BG, VRAM_B_MAIN_BG, VRAM_C_MAIN_BG, VRAM_D_MAIN_BG);
	vramSetBankE(VRAM_E_MAIN_SPRITE);
	BG0_CR = BG_32x32 | BG_COLOR_256 | BG_MAP_BASE(0) | BG_TILE_BASE(1) | BG_PRIORITY(1); // OS
	BG1_CR = BG_32x32 | BG_COLOR_256 | BG_MAP_BASE(2) | BG_TILE_BASE(1) | BG_PRIORITY(2); // Computer
	BG2_CR = BG_32x32 | BG_COLOR_16 | BG_MAP_BASE(4) | BG_TILE_BASE(2) | BG_PRIORITY(2); // text
	BG3_CR = BG_BMP8_256x256 | BG_BMP_BASE(3) | BG_PRIORITY(3); // Cables and bitmaps
	BG0_X0 = -Computer::OFFSET;
   	BG0_Y0 = -Computer::OFFSET;
	BG3_XDX = 1 << 8;
	BG3_XDY = 0;
	BG3_YDX = 0;
	BG3_YDY = 1 << 8;
	BG3_CX = 0;
	BG3_CY = 0;
	memset((u16*)SCREEN_BASE_BLOCK(0), 0, 32*24*2);
	memset((u16*)SCREEN_BASE_BLOCK(2), 0, 32*24*2);
	memset((u16*)BG_BMP_RAM(3), 0, 256*192);

	// setup the subscreen as a standard console
	videoSetModeSub(MODE_0_2D | DISPLAY_BG0_ACTIVE);
	vramSetBankH(VRAM_H_SUB_BG);
	SUB_BG0_CR = BG_MAP_BASE(8);
	BG_PALETTE_SUB[255] = RGB15(31,31,31);
	consoleInitDefault((u16*)SCREEN_BASE_BLOCK_SUB(8), (u16*)CHAR_BASE_BLOCK_SUB(0), 16);

	lcdMainOnBottom();

	// setup the FIFO
	REG_IPC_FIFO_CR = IPC_FIFO_ENABLE | IPC_FIFO_SEND_CLEAR;
	irqSet(IRQ_FIFO_NOT_EMPTY, FifoHandler);
	irqEnable(IRQ_FIFO_NOT_EMPTY);
	REG_IPC_FIFO_CR = IPC_FIFO_ENABLE | IPC_FIFO_RECV_IRQ;

	// init sound
	init_sound();

	// init FAT
	if(!fatInitDefault()) {
		iprintf("Unable to init media device!\n");
		iprintf("You will not be able to save\n");
		iprintf("or load high scores\n\n");
		iprintf("Press any button to continue.\n");
		do {
			scanKeys();
			swiWaitForVBlank();
		} while(!(keysDown() & (KEY_A | KEY_B | KEY_X | KEY_Y | KEY_START | KEY_TOUCH)));
	}

	// install the guru meditation handler
	defaultExceptionHandler();

	srand(time(0));

	// load images
	dmaCopy((u8*)CHAR_BASE_BLOCK_SUB(0), (u8*)CHAR_BASE_BLOCK(2), 256 * 16);
	dmaCopy(billspritePal, (u16*)BG_PALETTE, billspritePalLen);
	dmaCopy(systemscolorTiles, (u8*)CHAR_BASE_BLOCK(1) + 64, systemscolorTilesLen);
	dmaCopy(oscolorTiles, (u8*)CHAR_BASE_BLOCK(1) + 64 + systemscolorTilesLen, oscolorTilesLen);
	dmaCopy(billspritePal, (u16*)SPRITE_PALETTE, billspritePalLen);
	dmaCopy(billspriteTiles, (u8*)SPRITE_GFX, billspriteTilesLen);
	dmaCopy(extrasspriteTiles, (u8*)SPRITE_GFX + billspriteTilesLen, extrasspriteTilesLen);
	dmaCopy(swapspriteTiles, (u8*)SPRITE_GFX + billspriteTilesLen + extrasspriteTilesLen, swapspriteTilesLen);
	bill_pic.pic_type = PIC_BILL;
	extras_pic.pic_type = PIC_EXTRAS;
	swap_pic.pic_type = PIC_SWAP;
	os_pic.pic_type = PIC_OS;
	systems_pic.pic_type = PIC_SYSTEMS;

	BG_PALETTE[0] = RGB15(31, 31, 31); // white background
	BG_PALETTE[255] = RGB15(0, 0, 0); // default to black text for printing on main screen

	// set sane defaults for our sprites, and disable them all by default
	int i;
	for(i = 0; i < 128; i++) {
		sprites[i].attribute[0] = ATTR0_DISABLED;
		sprites[i].attribute[1] = 0;
		sprites[i].attribute[2] = 0;
		sprites[i].attribute[3] = 0;
	}
	sprite_rot[0].hdx = 256;
	sprite_rot[0].hdy = 0;
	sprite_rot[0].vdx = 0;
	sprite_rot[0].vdy = 256;

	double_buffer_init();

	iprintf("dsBill\n");
	iprintf("By Dopefish\n");
	iprintf("http://vespenegas.com\n");

	savegame.playing = 0;
	savegame.score = 0;
	savegame.level = 1;
	hscores.load();

	if(savegame.playing)
		game.start(savegame.level);
	else
		game.state = game.SETUP;

	u32 kd;
	touchPosition tp;
	int pen_down = 0, pen_x = 0, pen_y = 0;
	int warp_level = 1;
	int ticks = 0;

	// main loop
	while(1) {
		scanKeys();
		kd = keysDown();

		// draw the UI as necessary
		if(game.state == Game::SETUP) {
			load_bitmap(titleBitmap, titleBitmapLen);
			main_screen_gotoxy(7, 8);
			main_screen_printf("%d", warp_level);
			hscores.draw(0);
			double_buffer();
		} else if(game.state == Game::BETWEEN) {
			load_bitmap(betweenBitmap, betweenBitmapLen);
		} else if(game.state == Game::PAUSE) {
			load_bitmap(pauseBitmap, pauseBitmapLen);
		} else if(game.state == Game::END) {
			load_bitmap(gameoverBitmap, gameoverBitmapLen);
		}

		// turn on/off sprite layer as necessary
		if(game.state == Game::PLAYING) {
			DISPLAY_CR |= DISPLAY_SPR_ACTIVE;
		} else {
			DISPLAY_CR &= ~DISPLAY_SPR_ACTIVE;
		}

		// check for input
		if(keysHeld() & KEY_LID) {
			if(game.state == Game::PLAYING)
				game.state = Game::PAUSE;
			enter_sleep_mode();
		}
		if(keysHeld() & KEY_TOUCH) {
			tp = touchReadXY();
			pen_x = tp.px;
			pen_y = tp.py;

			if(!pen_down) {
				// pen down
				pen_down = 1;

				switch(game.state) {
					case Game::SETUP:
						if(tp.px >= 4 && tp.py >= 74 && tp.px <= 84 && tp.py <= 91) {
							for(i = 0; i < 128; i++)
								remove_sprite(i);
							game.start(warp_level);
						} else if(tp.px >= 74 && tp.px <= 86 && tp.py >= 57 && tp.py <= 64) {
							warp_level++;
							if(warp_level > 99) warp_level = 99;
						} else if(tp.px >= 74 && tp.px <= 86 && tp.py >= 65 && tp.py <= 72) {
							warp_level--;
							if(warp_level < 1) warp_level = 1;
						} else if(tp.px >= 215 && tp.py >= 0 && tp.py <= 17) {
							load_bitmap(rulesBitmap, rulesBitmapLen);
							do { scanKeys(); swiWaitForVBlank(); } while(!(keysDown() & (KEY_A | KEY_B | KEY_START | KEY_TOUCH)));
						} else if(tp.px >= 215 && tp.py >= 21 && tp.py <= 36) {
							load_bitmap(storyBitmap, storyBitmapLen);
							do { scanKeys(); swiWaitForVBlank(); } while(!(keysDown() & (KEY_A | KEY_B | KEY_START | KEY_TOUCH)));
						} else if(tp.px >= 215 && tp.py >= 40 && tp.py <= 55) {
							load_bitmap(aboutBitmap, aboutBitmapLen);
							do { scanKeys(); swiWaitForVBlank(); } while(!(keysDown() & (KEY_A | KEY_B | KEY_START | KEY_TOUCH)));
						}
						break;
					case Game::BETWEEN:
						game.state = Game::PLAYING;
						ui.clear();
						ui.refresh();
						game.setup_level(++game.level);
						savegame.score = game.score;
						savegame.level = game.level;
						game.refresh();
						break;
					case Game::PAUSE:
						if(tp.px >= 28 && tp.px <= 106 && tp.py >= 117 && tp.py <= 133) {
							game.state = Game::PLAYING;
							game.refresh();
						} else if(tp.px >= 137 && tp.px <= 214 && tp.py >= 117 && tp.py <= 133) {
							game.state = Game::SETUP;
							savegame.playing = 0;
							hscores.add();
							hscores.save();
						}
						break;
					case Game::END:
						game.state = Game::SETUP;
						hscores.add();
						hscores.save();
						break;
					default:
						game.button_press(pen_x, pen_y);
				}
			} else {
				// pen move
				if(game.state == Game::PLAYING) {
					ui.draw_cursor(pen_x, pen_y);
				}
			}
		} else if(!(keysHeld() & KEY_TOUCH) && pen_down) {
			// pen up
			pen_down = 0;

			if(game.state == Game::PLAYING) {
				game.button_release(pen_x, pen_y);
				ui.draw_cursor(pen_x, pen_y);
			}
		}
		if(kd & KEY_START) {
			if(game.state == Game::PAUSE) {
				game.state = Game::PLAYING;
			} else if(game.state == Game::PLAYING) {
				game.state = Game::PAUSE;
			}
		}

		// game pacing
		if(game.state == Game::PLAYING) {
			ticks++;
			if(ticks >= 20) {
				game.update();
				ticks = 0;
			}
		}

		swiWaitForVBlank();

		DC_FlushRange(sprites, 128 * sizeof(SpriteEntry));
		dmaCopy(sprites, OAM, 128 * sizeof(SpriteEntry));
	}

	return 0;
}
