#ifndef __GRAPHICS_H
#define __GRAPHICS_H

#include "Picture.h"

extern Picture extras_pic, bill_pic, os_pic, swap_pic, systems_pic;

extern void double_buffer_init();
extern void double_buffer();
extern void draw_image(Picture pict, int pic_index, int x, int y, int which);
extern void Win2DrawChars(char *chars, int len, short x, short y);
extern void Win2DrawLine(short x1, short y1, short x2, short y2);
extern void Win2ClearScreen();

void remove_sprite(int index);
void draw_bill(int x, int y, int sprite, int index);
void draw_extras(int x, int y, int sprite, int index);
void draw_swap(int x, int y, int sprite, int index);
void draw_system(int x, int y, int sprite);
void draw_os(int x, int y, int sprite);

int find_available_sprite();
void done_with_sprite(int index);
void load_bitmap(const unsigned *src, int len);

void main_screen_print_char(int c);
void main_screen_print(char *str);
void main_screen_printf(char *fmt, ...);
void main_screen_gotoxy(int col, int row);

#define BILL_WIDTH 16
#define BILL_HEIGHT 24
#define SWAP_WIDTH 32
#define SWAP_HEIGHT 24
#define SYSTEMS_WIDTH 32
#define SYSTEMS_HEIGHT 24
#define EXTRAS_WIDTH 16
#define EXTRAS_HEIGHT 16
#define OS_WIDTH 16
#define OS_HEIGHT 16

#endif /* __GRAPHICS_H */
