#include <nds.h>
#include <stdio.h>
#include <string.h>
#include "objects.h"
#include "graphics.h"

/*********************/
/* Graphics routines */
/*********************/

void UI::set_cursor(int cursor) {

	switch (cursor) {
		case Game::BUCKETC:
			cursorPic = &extras_pic;
			cursorPicIndex = 0;
			break;
		case Game::DOWNC:
		case Game::DEFAULTC:
			cursorPic = NONE;
			break;
		default:
			cursorPic = &os_pic;
			cursorPicIndex = cursor;
	}
	if (cursorPic!=NONE)
		curx=999;
}

void UI::draw_cursor(int x,int y)
{
	if (!cursorPic) { remove_sprite(127); return; }
	x-=cursorPic->width/2;
	y-=cursorPic->height/2;
	draw(*cursorPic,cursorPicIndex,x,y, 127);
	curx=x;
	cury=y;
}

void UI::clear() {
	Win2ClearScreen();
}

void UI::refresh() {
	if (cursorPic&&curx!=999) {
		draw(*cursorPic,cursorPicIndex,curx,cury, 127);
	}
	double_buffer();
}

void UI::pause(long millis) {
	while(millis >= 16) {
		swiWaitForVBlank();
		millis -= 16;
	}
}

void UI::draw(Picture pict, int index, int x, int y, int which) {
	draw_image(pict, index, x, y, which);
}

void UI::draw_line(int x1, int y1, int x2, int y2) {
	Win2DrawLine(x1,y1,x2,y2);
}

void UI::draw_str(char *str, int x, int y) {
	Win2DrawChars(str,strlen(str),x,y);
}

#define MSG_WIDTH  220
#define MSG_HEIGHT 120
#define MSG_BORDER 5

void UI::show_msg(char *message) {
	Win2DrawChars(message, strlen(message), 0, 0);
	Win2ClearScreen();
}

/******************/
/* Other routines */
/******************/

void UI::show_scorebox(int level, int score) {
	char msg[40];
	sprintf(msg,"Level %d completed\nScore:%d.",level,score);
	show_msg(msg);
}
