#include <stdio.h>
#include <string.h>
#include <time.h>
#include "objects.h"
#include "graphics.h"
#define TYPE 'HISC'

Scorelist hscores;

void Scorelist::reset() {
	int i;
	for(i=0;i<NUM_SCORES;i++) {
		scores[i]=(NUM_SCORES-i)*50;
		levels[i]=1;
		dates[i] = time(0);
	}
	changed=1;
}

void Scorelist::load() {
	FILE *fp;

	fp = fopen("/dsbill.hi", "rb");
	if(!fp) {
		// Create database, if it doesn't exist, and save default game status.
		fp = fopen("/dsbill.hi", "wb");
		if(!fp) {
			return;
		}
		reset();
		fwrite(&hscores, sizeof(hscores), 1, fp);
		fclose(fp);
	} else {
		fread(&hscores, sizeof(hscores), 1, fp);
		fclose(fp);
	}
	changed=0;
}

void Scorelist::save () {
	FILE *fp;

	if (changed) {
		fp = fopen("/dsbill.hi", "wb");
		if(!fp) {
			return;
		}
		fwrite(&hscores, sizeof(hscores), 1, fp);
		fclose(fp);
	}
}

/*  Add new high score to list   */
int Scorelist::add () {
	unsigned long score=game.score;
	unsigned level=game.level;
	int i,j;
	if (score<=scores[NUM_SCORES-1])
		return -1;
	for(i=0;i<NUM_SCORES&&scores[i]>=score;i++);
	for(j=NUM_SCORES-2;j>=i;j--) {
		scores[j+1]=scores[j];
		levels[j+1]=levels[j];
		dates[j+1]=dates[j];
	}
	changed=1;
	scores[i]=score;
	levels[i]=level;
	dates[i] = time(0);
	return i;
}

void Scorelist::draw(int bold) {
	char s[20];
	int y = 16;
	int i;

	for(i=0;i<NUM_SCORES;i++) {
		sprintf(s,"%3u", levels[i]);
		main_screen_gotoxy(4, y);
		main_screen_print(s);

		sprintf(s,"%6lu",scores[i]);
		main_screen_gotoxy(10, y);
		main_screen_print(s);

		time_t now = time(0);
		struct tm* timeStruct = gmtime((const time_t *)&now);
		sprintf(s, "%02d/%02d/%04d", timeStruct->tm_mon + 1, timeStruct->tm_mday, timeStruct->tm_year + 1900);
		main_screen_gotoxy(18, y);
		main_screen_print(s);

		y++;
	}
}

