#include <stdio.h>
#include "objects.h"
#include "graphics.h"

void Monster::get_border() {
	int i=game.RAND(0,3);
	if (i%2==0) target_x=game.RAND(0, game.scrwidth-bill.width);
	else target_y=game.RAND(0, game.scrheight-bill.height);
	switch (i) {
		case 0: target_y=-bill.height-8; break;
		case 1: target_x=game.scrwidth+1; break;
		case 2: target_y=game.scrwidth+1; break;
		case 3: target_x=-bill.width-1; break;
	}
}

/*  Adds a bill to the in state*/
void Monster::enter(){
	state = IN;
	get_border();
	x = target_x; y=target_y;
	index = 0;
	cels = &bill_pic;
	celsIndex = bill.DCELS;
	cargo = OS.WINGDOWS;
	x_offset = -1;
	y_offset = -7;
	target_c = game.RAND(0, net.units-1);
	target_x = net.computers[target_c].x+net.width-XOFFSET;
	target_y = net.computers[target_c].y+YOFFSET;
	bill.on_screen++; bill.off_screen--;
}

/*  Moves bill toward his target - returns whether or not he moved */
int Monster::move (int mode) {
	int xdist = target_x - x;
	int ydist = target_y - y;
	int step = step_size(game.level);
	int dx, dy;
	int signx = xdist >= 0 ? 1 : -1;
	int signy = ydist >= 0 ? 1 : -1;
	xdist = game.ABS(xdist);
	ydist = game.ABS(ydist);
	if (!xdist && !ydist) return 0;
	else if (xdist<step && ydist<step) {
		x = target_x;
		y = target_y;
	}
	else {
		dx = (xdist*step*signx)/(xdist+ydist);
		dy = (ydist*step*signy)/(xdist+ydist);
		switch(mode) {
			case SLOW: break;
			case FAST: dx = 5*dx/4; dy = 5*dy/4; break;
		}
		x+=dx;
		y+=dy;
		if (dx<0) {
			cels = &bill_pic;
			celsIndex = bill.DCELS;
		} else if (dx>0) {
			cels = &bill_pic;
			celsIndex = bill.DCELS + bill.WCELS - 1;
		}
	}
	return 1;
}

void Monster::draw(int which) {
	switch (state) {
		case IN:
		case OUT:
		case DYING: draw_std(which); break;
		case AT: draw_at(which); break;
		case STRAY: draw_stray(which); break;
		default: break;
	}
}

/*  Update Bill's position */
void Monster::update_in(int which) {
	int moved = move(SLOW);
	if (!moved && (net.computers[target_c].os != OS.WINGDOWS)
		&& !(net.computers[target_c].busy))
	{
		net.computers[target_c].busy=1;
		cels = &swap_pic;
		celsIndex = 0;
		index=0;
		state = AT;
		return;
	}
	else if (!moved) {
		int i;
		do {
			i=game.RAND(0, net.units-1);
		} while (i == target_c);
		target_c = i;
		target_x = net.computers[target_c].x + net.width-XOFFSET;
		target_y = net.computers[target_c].y + YOFFSET;
	}
	index++;
	index%=bill.WCELS - 1;
	//y_offset+=(4*(index%2)-2);
}

/*  Update Bill standing at a computer  */
void Monster::update_at(int which) {
	int sys;
	if (index==0 && net.computers[target_c].os == OS.OFF) {
		index=6;
		sys = net.computers[target_c].find_stray();
		if (sys<0) cargo = -1;
		else {
			cargo = bill.list[sys].cargo;
			bill.list[sys].state = OFF;
		}
	}
	else index++;
	if (index == bill.ACELS) {
		y_offset = -7;
		x_offset = -1;
		get_border();
		index = 0;
		cels = &bill_pic;
		celsIndex = bill.DCELS;
		state = OUT;
		net.computers[target_c].busy=0;
		return;
	}
	y_offset = bill.height - OS.height;
	switch (index) {
	case 1 :
	case 2 : x -= 4; x_offset +=4; break;
	case 3 : x -= 5; x_offset +=5; break;
	case 4 : x += 2; x_offset -=2; break;
	case 5 : x += 1; x_offset -=1; break;
	case 6 :
		if (net.computers[target_c].os != OS.OFF) {
			net.base--; net.off++;
			cargo = net.computers[target_c].os;
		}
		else {
			x-=10; x_offset+=10;
		}
		net.computers[target_c].os = OS.OFF;
		y_offset = -7;
		x += 10;
		x_offset -=10;
		break;
	case 7 : sy = y_offset; sx = -1; break;
	case 8 : sy = -7; sx = -1; break;
	case 9 : sy = -4; sx = -4; x -= 4; x_offset +=4; break;
	case 10 : sy = 0; sx = -4; x -= 7; x_offset +=7; break;
	case 11 : sy = 0; sx = -4;
		net.computers[target_c].os = OS.WINGDOWS;
		net.off--; net.win++;
		break;
	case 12 : x += 6; x_offset -=6;
	}
}

/* Updates Bill fleeing with his ill gotten gain */
void Monster::update_out(int which) {
	if (game.INTERSECT(x, y, bill.width, bill.height, 0, 0, game.scrwidth,
		game.scrheight))
	{
		move(FAST);
		index++;
		index%=bill.WCELS - 1;
		//y_offset+=(4*(index%2)-2);
	}
	else {
		state = OFF;
		bill.on_screen--; bill.off_screen++;
		remove_sprite(which);
	}
}


/* Updates Bill who is dying */
void Monster::update_dying(int which) {
	if (index < bill.DCELS-1){
		y_offset += (index*GRAVITY);
		index++;
	}
	else {
		y+=y_offset;
		if (cargo<0 || cargo == OS.WINGDOWS) state = OFF;
		else state = STRAY;
		bill.on_screen--;
		remove_sprite(which);
	}
}

void Monster::update(int which) {
	switch (state) {
		case IN: update_in(which); break;
		case AT: update_at(which); break;
		case OUT: update_out(which); break;
		case DYING: update_dying(which); break;
		default: break;
	}
}

int Monster::clicked(int locx, int locy) {
	return (locx>=x-2 && locx<=x+bill.width+4 && locy>=y-2 && locy<=y+bill.height+4);
}

int Monster::clickedstray(int locx, int locy) {
	return (locx>=x && locx<=x+OS.width && locy>=y && locy<=y+OS.height);
}

int Monster::step_size(unsigned int lev) {
	return game.MIN(7+lev/2, 9);
}

void Monster::draw_std(int which) {
	if (cargo>=0)
		ui.draw(os_pic, cargo, x + x_offset, y + y_offset, 0);
	ui.draw(*cels, celsIndex + index, x, y, which);
}

void Monster::draw_at(int which) {
	if (index>6 && index<12)
		ui.draw(os_pic, 0, x + sx, y + sy, 0);
	if (cargo>=0)
		ui.draw(os_pic, cargo, x + x_offset, y + y_offset, 0);
	ui.draw(*cels, celsIndex + index, net.computers[target_c].x,
		net.computers[target_c].y, which);
}

void Monster::draw_stray(int which) {
	if (game.grabbed==-1 || x != bill.list[game.grabbed].x)
		ui.draw(os_pic, cargo, x, y, 0);
}
